/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat;

import com.azure.communication.chat.ChatServiceVersion;
import com.azure.communication.chat.ChatThreadAsyncClient;
import com.azure.communication.chat.ChatThreadClient;
import com.azure.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.communication.chat.implementation.AzureCommunicationChatServiceImplBuilder;
import com.azure.communication.chat.implementation.CommunicationBearerTokenCredential;
import com.azure.communication.common.CommunicationTokenCredential;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ChatThreadAsyncClient.class, ChatThreadClient.class})
public final class ChatThreadClientBuilder
implements ConfigurationTrait<ChatThreadClientBuilder>,
EndpointTrait<ChatThreadClientBuilder>,
HttpTrait<ChatThreadClientBuilder> {
    private String chatThreadId;
    private String endpoint;
    private HttpClient httpClient;
    private CommunicationTokenCredential communicationTokenCredential;
    private final List<HttpPipelinePolicy> customPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions = new HttpLogOptions();
    private HttpPipeline httpPipeline;
    private Configuration configuration;
    private ClientOptions clientOptions;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private static final String APP_CONFIG_PROPERTIES = "azure-communication-chat.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";

    public ChatThreadClientBuilder endpoint(String endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        return this;
    }

    public ChatThreadClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
        return this;
    }

    public ChatThreadClientBuilder credential(CommunicationTokenCredential communicationTokenCredential) {
        this.communicationTokenCredential = Objects.requireNonNull(communicationTokenCredential, "'communicationTokenCredential' cannot be null.");
        return this;
    }

    public ChatThreadClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ChatThreadClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.customPolicies.add(Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null."));
        return this;
    }

    public ChatThreadClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ChatThreadClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public ChatThreadClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public ChatThreadClientBuilder serviceVersion(ChatServiceVersion version) {
        return this;
    }

    public ChatThreadClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        return this;
    }

    public ChatThreadClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ChatThreadClientBuilder chatThreadId(String chatThreadId) {
        this.chatThreadId = Objects.requireNonNull(chatThreadId, "'chatThreadId' cannot be null.");
        return this;
    }

    public ChatThreadClient buildClient() {
        Objects.requireNonNull(this.chatThreadId);
        ChatThreadAsyncClient asyncClient = this.buildAsyncClient();
        return new ChatThreadClient(asyncClient);
    }

    public ChatThreadAsyncClient buildAsyncClient() {
        Objects.requireNonNull(this.chatThreadId);
        AzureCommunicationChatServiceImpl internalClient = this.createInternalClient();
        return new ChatThreadAsyncClient(internalClient, this.chatThreadId);
    }

    private AzureCommunicationChatServiceImpl createInternalClient() {
        HttpPipeline pipeline;
        Objects.requireNonNull(this.endpoint);
        if (this.httpPipeline != null) {
            pipeline = this.httpPipeline;
        } else {
            Objects.requireNonNull(this.communicationTokenCredential);
            Objects.requireNonNull(this.httpClient);
            CommunicationBearerTokenCredential tokenCredential = new CommunicationBearerTokenCredential(this.communicationTokenCredential);
            pipeline = this.createHttpPipeline(this.httpClient, (HttpPipelinePolicy)new BearerTokenAuthenticationPolicy((TokenCredential)tokenCredential, new String[]{""}), this.customPolicies);
        }
        AzureCommunicationChatServiceImplBuilder clientBuilder = new AzureCommunicationChatServiceImplBuilder().endpoint(this.endpoint).pipeline(pipeline);
        return clientBuilder.buildClient();
    }

    private HttpPipeline createHttpPipeline(HttpClient httpClient, HttpPipelinePolicy authorizationPolicy, List<HttpPipelinePolicy> additionalPolicies) {
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(this.getUserAgentPolicy());
        policies.add(new RequestIdPolicy());
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions));
        policies.add(new CookiePolicy());
        policies.add(authorizationPolicy);
        policies.add(new HttpLoggingPolicy(this.logOptions));
        if (additionalPolicies != null && additionalPolicies.size() > 0) {
            policies.addAll(additionalPolicies);
        }
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).build();
    }

    private UserAgentPolicy getUserAgentPolicy() {
        Map properties = CoreUtils.getProperties((String)APP_CONFIG_PROPERTIES);
        String clientName = properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = this.logOptions.getApplicationId();
        if (this.clientOptions != null) {
            applicationId = this.clientOptions.getApplicationId();
        }
        return new UserAgentPolicy(applicationId, clientName, clientVersion, this.configuration);
    }
}

