/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.communication.chat.models.ChatRetentionPolicy;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class UpdateChatThreadOptions
implements JsonSerializable<UpdateChatThreadOptions> {
    private String topic;
    private Map<String, String> metadata;
    private ChatRetentionPolicy retentionPolicy;

    public String getTopic() {
        return this.topic;
    }

    public UpdateChatThreadOptions setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public UpdateChatThreadOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ChatRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public UpdateChatThreadOptions setRetentionPolicy(ChatRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("retentionPolicy", (JsonSerializable)this.retentionPolicy);
        return jsonWriter.writeEndObject();
    }

    public static UpdateChatThreadOptions fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateChatThreadOptions)jsonReader.readObject(reader -> {
            UpdateChatThreadOptions deserializedUpdateChatThreadOptions = new UpdateChatThreadOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("topic".equals(fieldName)) {
                    deserializedUpdateChatThreadOptions.topic = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedUpdateChatThreadOptions.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("retentionPolicy".equals(fieldName)) {
                    deserializedUpdateChatThreadOptions.retentionPolicy = ChatRetentionPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateChatThreadOptions;
        });
    }
}

