/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.communication.chat.models.ChatParticipant;
import com.azure.communication.chat.models.ChatRetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class CreateChatThreadOptions {
    private final String topic;
    private List<ChatParticipant> participants = new ArrayList<ChatParticipant>();
    private Map<String, String> metadata = new HashMap<String, String>();
    private ChatRetentionPolicy retentionPolicy;
    private String idempotencyToken;

    public String getTopic() {
        return this.topic;
    }

    public List<ChatParticipant> getParticipants() {
        return this.participants;
    }

    public CreateChatThreadOptions setParticipants(List<ChatParticipant> participants) {
        this.participants = participants;
        return this;
    }

    public CreateChatThreadOptions addParticipant(ChatParticipant participant) {
        this.participants.add(participant);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CreateChatThreadOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ChatRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public CreateChatThreadOptions setRetentionPolicy(ChatRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public CreateChatThreadOptions setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
        return this;
    }

    public CreateChatThreadOptions(String topic) {
        this.topic = topic;
        this.idempotencyToken = UUID.randomUUID().toString();
    }
}

