/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.communication.chat.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.chat.models.ChatRetentionPolicy;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

public final class ChatThreadProperties
implements JsonSerializable<ChatThreadProperties> {
    private String id;
    private String topic;
    private OffsetDateTime createdOn;
    private CommunicationIdentifier createdBy;
    private Map<String, String> metadata = new HashMap<String, String>();
    private ChatRetentionPolicy retentionPolicy;

    public String getId() {
        return this.id;
    }

    public ChatThreadProperties setId(String id) {
        this.id = id;
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public ChatThreadProperties setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public ChatThreadProperties setCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public CommunicationIdentifier getCreatedBy() {
        return this.createdBy;
    }

    public ChatThreadProperties setCreatedBy(CommunicationIdentifier createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ChatThreadProperties setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ChatRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public ChatThreadProperties setRetentionPolicy(ChatRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeStringField("createdOn", this.createdOn != null ? this.createdOn.toString() : null);
        CommunicationIdentifierModel identifier = CommunicationIdentifierConverter.convert(this.createdBy);
        jsonWriter.writeJsonField("createdBy", (JsonSerializable)identifier);
        jsonWriter.writeStartObject("metadata");
        for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
            jsonWriter.writeStringField(entry.getKey(), entry.getValue());
        }
        jsonWriter.writeEndObject();
        if (this.retentionPolicy != null) {
            jsonWriter.writeJsonField("retentionPolicy", (JsonSerializable)this.retentionPolicy);
        }
        return jsonWriter.writeEndObject();
    }

    public static ChatThreadProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ChatThreadProperties)jsonReader.readObject(reader -> {
            ChatThreadProperties properties = new ChatThreadProperties();
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    properties.setId(reader.getString());
                    continue;
                }
                if ("topic".equals(fieldName)) {
                    properties.setTopic(reader.getString());
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    String value = reader.getString();
                    if (CoreUtils.isNullOrEmpty((CharSequence)value)) continue;
                    properties.setCreatedOn(OffsetDateTime.parse(value));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    CommunicationIdentifierModel identifier = (CommunicationIdentifierModel)reader.readObject(CommunicationIdentifierModel::fromJson);
                    properties.setCreatedBy(CommunicationIdentifierConverter.convert(identifier));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    properties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("retentionPolicy".equals(fieldName)) {
                    properties.retentionPolicy = ChatRetentionPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return properties;
        });
    }
}

