/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.communication.chat.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ChatParticipant
implements JsonSerializable<ChatParticipant> {
    private CommunicationIdentifier communicationIdentifier;
    private String displayName;
    private OffsetDateTime shareHistoryTime;
    private Map<String, String> metadata;

    public CommunicationIdentifier getCommunicationIdentifier() {
        return this.communicationIdentifier;
    }

    public ChatParticipant setCommunicationIdentifier(CommunicationIdentifier communicationIdentifier) {
        this.communicationIdentifier = communicationIdentifier;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ChatParticipant setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime getShareHistoryTime() {
        return this.shareHistoryTime;
    }

    public ChatParticipant setShareHistoryTime(OffsetDateTime shareHistoryTime) {
        this.shareHistoryTime = shareHistoryTime;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ChatParticipant setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        CommunicationIdentifierModel identifier = CommunicationIdentifierConverter.convert(this.communicationIdentifier);
        jsonWriter.writeJsonField("communicationIdentifier", (JsonSerializable)identifier);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("startDateTime", this.shareHistoryTime.toString());
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ChatParticipant fromJson(JsonReader jsonReader) throws IOException {
        return (ChatParticipant)jsonReader.readObject(reader -> {
            ChatParticipant participant = new ChatParticipant();
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("communicationIdentifier".equals(fieldName)) {
                    CommunicationIdentifierModel identifier = (CommunicationIdentifierModel)reader.readObject(CommunicationIdentifierModel::fromJson);
                    participant.communicationIdentifier = CommunicationIdentifierConverter.convert(identifier);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    participant.displayName = reader.getString();
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    participant.shareHistoryTime = OffsetDateTime.parse(reader.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    participant.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return participant;
        });
    }
}

