/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.communication.chat.models.ChatAttachmentType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatAttachment
implements JsonSerializable<ChatAttachment> {
    private final String id;
    private final ChatAttachmentType attachmentType;
    private String name;
    private String url;
    private String previewUrl;

    public ChatAttachment(String id, ChatAttachmentType attachmentType) {
        this.id = id;
        this.attachmentType = attachmentType;
    }

    public String getId() {
        return this.id;
    }

    public ChatAttachmentType getAttachmentType() {
        return this.attachmentType;
    }

    public String getName() {
        return this.name;
    }

    public ChatAttachment setName(String name) {
        this.name = name;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public ChatAttachment setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public ChatAttachment setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("attachmentType", this.attachmentType != null ? this.attachmentType.toString() : null);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("previewUrl", this.previewUrl);
        return jsonWriter.writeEndObject();
    }

    public static ChatAttachment fromJson(JsonReader jsonReader) throws IOException {
        return (ChatAttachment)jsonReader.readObject(reader -> {
            String id = null;
            ChatAttachmentType attachmentType = null;
            String name = null;
            String url = null;
            String previewUrl = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("attachmentType".equals(fieldName)) {
                    attachmentType = ChatAttachmentType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("previewUrl".equals(fieldName)) {
                    previewUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new ChatAttachment(id, attachmentType).setName(name).setUrl(url).setPreviewUrl(previewUrl);
        });
    }
}

