/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ChatThreadItem
implements JsonSerializable<ChatThreadItem> {
    private String id;
    private String topic;
    private OffsetDateTime deletedOn;
    private OffsetDateTime lastMessageReceivedOn;

    public String getId() {
        return this.id;
    }

    public ChatThreadItem setId(String id) {
        this.id = id;
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public ChatThreadItem setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public OffsetDateTime getDeletedOn() {
        return this.deletedOn;
    }

    public ChatThreadItem setDeletedOn(OffsetDateTime deletedOn) {
        this.deletedOn = deletedOn;
        return this;
    }

    public OffsetDateTime getLastMessageReceivedOn() {
        return this.lastMessageReceivedOn;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeStringField("deletedOn", this.deletedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedOn));
        return jsonWriter.writeEndObject();
    }

    public static ChatThreadItem fromJson(JsonReader jsonReader) throws IOException {
        return (ChatThreadItem)jsonReader.readObject(reader -> {
            ChatThreadItem deserializedChatThreadItem = new ChatThreadItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedChatThreadItem.id = reader.getString();
                    continue;
                }
                if ("topic".equals(fieldName)) {
                    deserializedChatThreadItem.topic = reader.getString();
                    continue;
                }
                if ("deletedOn".equals(fieldName)) {
                    deserializedChatThreadItem.deletedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("lastMessageReceivedOn".equals(fieldName)) {
                    deserializedChatThreadItem.lastMessageReceivedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChatThreadItem;
        });
    }
}

