/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.implementation.models;

import com.azure.communication.chat.implementation.models.ChatAttachment;
import com.azure.communication.chat.implementation.models.ChatParticipant;
import com.azure.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatMessageContent
implements JsonSerializable<ChatMessageContent> {
    private String message;
    private String topic;
    private List<ChatParticipant> participants;
    private List<ChatAttachment> attachments;
    private CommunicationIdentifierModel initiatorCommunicationIdentifier;

    public String getMessage() {
        return this.message;
    }

    public ChatMessageContent setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public ChatMessageContent setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public List<ChatParticipant> getParticipants() {
        return this.participants;
    }

    public ChatMessageContent setParticipants(List<ChatParticipant> participants) {
        this.participants = participants;
        return this;
    }

    public List<ChatAttachment> getAttachments() {
        return this.attachments;
    }

    public ChatMessageContent setAttachments(List<ChatAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public CommunicationIdentifierModel getInitiatorCommunicationIdentifier() {
        return this.initiatorCommunicationIdentifier;
    }

    public ChatMessageContent setInitiatorCommunicationIdentifier(CommunicationIdentifierModel initiatorCommunicationIdentifier) {
        this.initiatorCommunicationIdentifier = initiatorCommunicationIdentifier;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeArrayField("participants", this.participants, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("initiatorCommunicationIdentifier", (JsonSerializable)this.initiatorCommunicationIdentifier);
        return jsonWriter.writeEndObject();
    }

    public static ChatMessageContent fromJson(JsonReader jsonReader) throws IOException {
        return (ChatMessageContent)jsonReader.readObject(reader -> {
            ChatMessageContent deserializedChatMessageContent = new ChatMessageContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message".equals(fieldName)) {
                    deserializedChatMessageContent.message = reader.getString();
                    continue;
                }
                if ("topic".equals(fieldName)) {
                    deserializedChatMessageContent.topic = reader.getString();
                    continue;
                }
                if ("participants".equals(fieldName)) {
                    List participants;
                    deserializedChatMessageContent.participants = participants = reader.readArray(reader1 -> ChatParticipant.fromJson(reader1));
                    continue;
                }
                if ("attachments".equals(fieldName)) {
                    List attachments;
                    deserializedChatMessageContent.attachments = attachments = reader.readArray(reader1 -> ChatAttachment.fromJson(reader1));
                    continue;
                }
                if ("initiatorCommunicationIdentifier".equals(fieldName)) {
                    deserializedChatMessageContent.initiatorCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChatMessageContent;
        });
    }
}

