/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat;

import com.azure.communication.chat.ChatThreadClientBuilder;
import com.azure.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.communication.chat.implementation.ChatThreadsImpl;
import com.azure.communication.chat.implementation.converters.AddChatParticipantsOptionsConverter;
import com.azure.communication.chat.implementation.converters.AddChatParticipantsResultConverter;
import com.azure.communication.chat.implementation.converters.ChatErrorConverter;
import com.azure.communication.chat.implementation.converters.ChatMessageConverter;
import com.azure.communication.chat.implementation.converters.ChatMessageReadReceiptConverter;
import com.azure.communication.chat.implementation.converters.ChatParticipantConverter;
import com.azure.communication.chat.implementation.converters.ChatThreadPropertiesConverter;
import com.azure.communication.chat.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.chat.implementation.models.ChatMessage;
import com.azure.communication.chat.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.chat.implementation.models.SendReadReceiptRequest;
import com.azure.communication.chat.models.AddChatParticipantsResult;
import com.azure.communication.chat.models.ChatError;
import com.azure.communication.chat.models.ChatErrorResponseException;
import com.azure.communication.chat.models.ChatMessageReadReceipt;
import com.azure.communication.chat.models.ChatParticipant;
import com.azure.communication.chat.models.ChatThreadProperties;
import com.azure.communication.chat.models.InvalidParticipantException;
import com.azure.communication.chat.models.ListChatMessagesOptions;
import com.azure.communication.chat.models.ListParticipantsOptions;
import com.azure.communication.chat.models.ListReadReceiptOptions;
import com.azure.communication.chat.models.SendChatMessageOptions;
import com.azure.communication.chat.models.SendChatMessageResult;
import com.azure.communication.chat.models.TypingNotificationOptions;
import com.azure.communication.chat.models.UpdateChatMessageOptions;
import com.azure.communication.chat.models.UpdateChatThreadOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.paging.PageRetriever;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ChatThreadClientBuilder.class, isAsync=true)
public final class ChatThreadAsyncClient {
    private final ClientLogger logger = new ClientLogger(ChatThreadAsyncClient.class);
    private final AzureCommunicationChatServiceImpl chatServiceClient;
    private final ChatThreadsImpl chatThreadClient;
    private final String chatThreadId;

    ChatThreadAsyncClient(AzureCommunicationChatServiceImpl chatServiceClient, String chatThreadId) {
        this.chatServiceClient = chatServiceClient;
        this.chatThreadClient = chatServiceClient.getChatThreads();
        this.chatThreadId = chatThreadId;
    }

    public String getChatThreadId() {
        return this.chatThreadId;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateTopic(String topic) {
        try {
            Objects.requireNonNull(topic, "'topic' cannot be null.");
            return FluxUtil.withContext(context -> this.updateTopic(topic, (Context)context).flatMap(res -> Mono.empty()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateTopicWithResponse(String topic) {
        try {
            Objects.requireNonNull(topic, "'topic' cannot be null.");
            return FluxUtil.withContext(context -> this.updateTopic(topic, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> updateTopic(String topic, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.chatThreadClient.updateChatThreadPropertiesWithResponseAsync(this.chatThreadId, new UpdateChatThreadOptions().setTopic(topic), context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateThreadProperties(UpdateChatThreadOptions options) {
        try {
            Objects.requireNonNull(options, "'options' cannot be null.");
            return FluxUtil.withContext(context -> this.updateThreadProperties(options, (Context)context).flatMap(res -> Mono.empty()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateThreadPropertiesWithResponse(UpdateChatThreadOptions options) {
        try {
            Objects.requireNonNull(options, "'options' cannot be null.");
            return FluxUtil.withContext(context -> this.updateThreadProperties(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> updateThreadProperties(UpdateChatThreadOptions options, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.chatThreadClient.updateChatThreadPropertiesWithResponseAsync(this.chatThreadId, options, context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddChatParticipantsResult> addParticipants(Iterable<ChatParticipant> participants) {
        try {
            Objects.requireNonNull(participants, "'participants' cannot be null.");
            return FluxUtil.withContext(context -> this.addParticipants(participants, (Context)context).flatMap(res -> Mono.just((Object)((AddChatParticipantsResult)res.getValue()))));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddChatParticipantsResult>> addParticipantsWithResponse(Iterable<ChatParticipant> participants) {
        try {
            Objects.requireNonNull(participants, "'participants' cannot be null.");
            return FluxUtil.withContext(context -> this.addParticipants(participants, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addParticipant(ChatParticipant participant) {
        return FluxUtil.withContext(context -> this.addParticipantWithResponse(participant, (Context)context).flatMap(resp -> Mono.empty()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addParticipantWithResponse(ChatParticipant participant) {
        try {
            return FluxUtil.withContext(context -> this.addParticipantWithResponse(participant, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> addParticipantWithResponse(ChatParticipant participant, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.addParticipants(Collections.singletonList(participant), context).flatMap(res -> {
                if (((AddChatParticipantsResult)res.getValue()).getInvalidParticipants() != null && ((AddChatParticipantsResult)res.getValue()).getInvalidParticipants().size() > 0) {
                    ChatError error = (ChatError)((AddChatParticipantsResult)res.getValue()).getInvalidParticipants().stream().findFirst().get();
                    return Mono.error((Throwable)((Object)new InvalidParticipantException(error)));
                }
                return Mono.empty();
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AddChatParticipantsResult>> addParticipants(Iterable<ChatParticipant> participants, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.chatThreadClient.addChatParticipantsWithResponseAsync(this.chatThreadId, AddChatParticipantsOptionsConverter.convert(participants), context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e))).map(result -> new SimpleResponse(result, (Object)AddChatParticipantsResultConverter.convert((com.azure.communication.chat.implementation.models.AddChatParticipantsResult)result.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeParticipant(CommunicationIdentifier identifier) {
        try {
            Objects.requireNonNull(identifier, "'identifier' cannot be null.");
            return FluxUtil.withContext(context -> this.removeParticipant(identifier, (Context)context).flatMap(res -> Mono.empty()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeParticipantWithResponse(CommunicationIdentifier identifier) {
        try {
            Objects.requireNonNull(identifier, "'identifier' cannot be null.");
            return FluxUtil.withContext(context -> this.removeParticipant(identifier, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> removeParticipant(CommunicationIdentifier identifier, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.chatThreadClient.removeChatParticipantWithResponseAsync(this.chatThreadId, CommunicationIdentifierConverter.convert(identifier), context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatParticipant> listParticipants() {
        ListParticipantsOptions listParticipantsOptions = new ListParticipantsOptions();
        return this.listParticipants(listParticipantsOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatParticipant> listParticipants(ListParticipantsOptions listParticipantsOptions) {
        ListParticipantsOptions serviceListParticipantsOptions = listParticipantsOptions == null ? new ListParticipantsOptions() : listParticipantsOptions;
        try {
            return this.pagedFluxConvert(new PagedFlux(() -> FluxUtil.withContext(context -> this.chatThreadClient.listChatParticipantsSinglePageAsync(this.chatThreadId, serviceListParticipantsOptions.getMaxPageSize(), serviceListParticipantsOptions.getSkip(), (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e)))))), nextLink -> FluxUtil.withContext(context -> this.chatThreadClient.listChatParticipantsNextSinglePageAsync((String)nextLink, (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e))))))), f -> ChatParticipantConverter.convert(f));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<ChatParticipant> listParticipants(ListParticipantsOptions listParticipantsOptions, Context context) {
        Context serviceContext = context == null ? Context.NONE : context;
        ListParticipantsOptions serviceListParticipantsOptions = listParticipantsOptions == null ? new ListParticipantsOptions() : listParticipantsOptions;
        try {
            return this.pagedFluxConvert(new PagedFlux(() -> this.chatThreadClient.listChatParticipantsSinglePageAsync(this.chatThreadId, serviceListParticipantsOptions.getMaxPageSize(), serviceListParticipantsOptions.getSkip(), serviceContext).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)e)))), nextLink -> this.chatThreadClient.listChatParticipantsNextSinglePageAsync((String)nextLink, serviceContext).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)e))))), f -> ChatParticipantConverter.convert(f));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SendChatMessageResult> sendMessage(SendChatMessageOptions options) {
        try {
            Objects.requireNonNull(options, "'options' cannot be null.");
            return FluxUtil.withContext(context -> this.sendMessage(options, (Context)context).flatMap(res -> Mono.just((Object)((SendChatMessageResult)res.getValue()))));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SendChatMessageResult>> sendMessageWithResponse(SendChatMessageOptions options) {
        try {
            Objects.requireNonNull(options, "'options' cannot be null.");
            return FluxUtil.withContext(context -> this.sendMessage(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<SendChatMessageResult>> sendMessage(SendChatMessageOptions options, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.chatThreadClient.sendChatMessageWithResponseAsync(this.chatThreadId, options, context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e))).map(result -> new SimpleResponse(result, (Object)((SendChatMessageResult)result.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<com.azure.communication.chat.models.ChatMessage> getMessage(String chatMessageId) {
        try {
            Objects.requireNonNull(chatMessageId, "'chatMessageId' cannot be null.");
            return FluxUtil.withContext(context -> this.getMessage(chatMessageId, (Context)context).flatMap(res -> {
                if (res.getValue() != null) {
                    return Mono.just((Object)((com.azure.communication.chat.models.ChatMessage)res.getValue()));
                }
                return Mono.empty();
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<com.azure.communication.chat.models.ChatMessage>> getMessageWithResponse(String chatMessageId) {
        try {
            Objects.requireNonNull(chatMessageId, "'chatMessageId' cannot be null.");
            return FluxUtil.withContext(context -> this.getMessage(chatMessageId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<com.azure.communication.chat.models.ChatMessage>> getMessage(String chatMessageId, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.chatThreadClient.getChatMessageWithResponseAsync(this.chatThreadId, chatMessageId, context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e))).map(result -> new SimpleResponse(result, (Object)ChatMessageConverter.convert((ChatMessage)result.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<com.azure.communication.chat.models.ChatMessage> listMessages() {
        ListChatMessagesOptions listMessagesOptions = new ListChatMessagesOptions();
        try {
            return this.pagedFluxConvert(new PagedFlux(() -> FluxUtil.withContext(context -> this.chatThreadClient.listChatMessagesSinglePageAsync(this.chatThreadId, listMessagesOptions.getMaxPageSize(), listMessagesOptions.getStartTime(), (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e)))))), nextLink -> FluxUtil.withContext(context -> this.chatThreadClient.listChatMessagesNextSinglePageAsync((String)nextLink, (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e))))))), f -> ChatMessageConverter.convert(f));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<com.azure.communication.chat.models.ChatMessage> listMessages(ListChatMessagesOptions listMessagesOptions) {
        ListChatMessagesOptions serviceListMessagesOptions = listMessagesOptions == null ? new ListChatMessagesOptions() : listMessagesOptions;
        try {
            return this.pagedFluxConvert(new PagedFlux(() -> FluxUtil.withContext(context -> this.chatThreadClient.listChatMessagesSinglePageAsync(this.chatThreadId, serviceListMessagesOptions.getMaxPageSize(), serviceListMessagesOptions.getStartTime(), (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e)))))), nextLink -> FluxUtil.withContext(context -> this.chatThreadClient.listChatMessagesNextSinglePageAsync((String)nextLink, (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e))))))), f -> ChatMessageConverter.convert(f));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<com.azure.communication.chat.models.ChatMessage> listMessages(ListChatMessagesOptions listMessagesOptions, Context context) {
        ListChatMessagesOptions serviceListMessagesOptions = listMessagesOptions == null ? new ListChatMessagesOptions() : listMessagesOptions;
        Context serviceContext = context == null ? Context.NONE : context;
        try {
            return this.pagedFluxConvert(new PagedFlux(() -> this.chatThreadClient.listChatMessagesSinglePageAsync(this.chatThreadId, serviceListMessagesOptions.getMaxPageSize(), serviceListMessagesOptions.getStartTime(), serviceContext).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)e)))), nextLink -> this.chatThreadClient.listChatMessagesNextSinglePageAsync((String)nextLink, serviceContext).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)e))))), f -> ChatMessageConverter.convert(f));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateMessage(String chatMessageId, UpdateChatMessageOptions options) {
        try {
            Objects.requireNonNull(chatMessageId, "'chatMessageId' cannot be null.");
            Objects.requireNonNull(options, "'options' cannot be null.");
            return FluxUtil.withContext(context -> this.updateMessage(chatMessageId, options, (Context)context).flatMap(res -> Mono.empty()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateMessageWithResponse(String chatMessageId, UpdateChatMessageOptions options) {
        try {
            Objects.requireNonNull(chatMessageId, "'chatMessageId' cannot be null.");
            Objects.requireNonNull(options, "'options' cannot be null.");
            return FluxUtil.withContext(context -> this.updateMessage(chatMessageId, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> updateMessage(String chatMessageId, UpdateChatMessageOptions options, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.chatThreadClient.updateChatMessageWithResponseAsync(this.chatThreadId, chatMessageId, options, context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteMessage(String chatMessageId) {
        try {
            Objects.requireNonNull(chatMessageId, "'chatMessageId' cannot be null.");
            return FluxUtil.withContext(context -> this.deleteMessage(chatMessageId, (Context)context).flatMap(res -> Mono.empty()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteMessageWithResponse(String chatMessageId) {
        try {
            Objects.requireNonNull(chatMessageId, "'chatMessageId' cannot be null.");
            return FluxUtil.withContext(context -> this.deleteMessage(chatMessageId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteMessage(String chatMessageId, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.chatThreadClient.deleteChatMessageWithResponseAsync(this.chatThreadId, chatMessageId, context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendTypingNotification() {
        try {
            TypingNotificationOptions options = new TypingNotificationOptions();
            return FluxUtil.withContext(context -> this.sendTypingNotification(options, (Context)context).flatMap(res -> Mono.empty()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendTypingNotificationWithResponse() {
        try {
            TypingNotificationOptions options = new TypingNotificationOptions();
            return FluxUtil.withContext(context -> this.sendTypingNotification(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendTypingNotificationWithResponse(TypingNotificationOptions options) {
        try {
            Objects.requireNonNull(options, "'options' cannot be null.");
            return FluxUtil.withContext(context -> this.sendTypingNotification(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> sendTypingNotification(TypingNotificationOptions options, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            Objects.requireNonNull(options, "'options' cannot be null.");
            return this.chatThreadClient.sendTypingNotificationWithResponseAsync(this.chatThreadId, options, context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendReadReceipt(String chatMessageId) {
        try {
            Objects.requireNonNull(chatMessageId, "'chatMessageId' cannot be null.");
            return FluxUtil.withContext(context -> this.sendReadReceipt(chatMessageId, (Context)context).flatMap(res -> Mono.empty()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendReadReceiptWithResponse(String chatMessageId) {
        try {
            Objects.requireNonNull(chatMessageId, "'chatMessageId' cannot be null.");
            return FluxUtil.withContext(context -> this.sendReadReceipt(chatMessageId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> sendReadReceipt(String chatMessageId, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            SendReadReceiptRequest request = new SendReadReceiptRequest().setChatMessageId(chatMessageId);
            return this.chatThreadClient.sendChatReadReceiptWithResponseAsync(this.chatThreadId, request, context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatMessageReadReceipt> listReadReceipts() {
        try {
            ListReadReceiptOptions listReadReceiptOptions = new ListReadReceiptOptions();
            return this.listReadReceipts(listReadReceiptOptions, Context.NONE);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatMessageReadReceipt> listReadReceipts(ListReadReceiptOptions listReadReceiptOptions) {
        ListReadReceiptOptions serviceListReadReceiptOptions = listReadReceiptOptions == null ? new ListReadReceiptOptions() : listReadReceiptOptions;
        try {
            return this.pagedFluxConvert(new PagedFlux(() -> FluxUtil.withContext(context -> this.chatThreadClient.listChatReadReceiptsSinglePageAsync(this.chatThreadId, serviceListReadReceiptOptions.getMaxPageSize(), serviceListReadReceiptOptions.getSkip(), (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e)))))), nextLink -> FluxUtil.withContext(context -> this.chatThreadClient.listChatReadReceiptsNextSinglePageAsync((String)nextLink, (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e))))))), f -> ChatMessageReadReceiptConverter.convert(f));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<ChatMessageReadReceipt> listReadReceipts(ListReadReceiptOptions listReadReceiptOptions, Context context) {
        Context serviceContext = context == null ? Context.NONE : context;
        ListReadReceiptOptions serviceListReadReceiptOptions = listReadReceiptOptions == null ? new ListReadReceiptOptions() : listReadReceiptOptions;
        try {
            return this.pagedFluxConvert(new PagedFlux(() -> this.chatThreadClient.listChatReadReceiptsSinglePageAsync(this.chatThreadId, serviceListReadReceiptOptions.getMaxPageSize(), serviceListReadReceiptOptions.getSkip(), serviceContext).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)e)))), nextLink -> this.chatThreadClient.listChatReadReceiptsNextSinglePageAsync((String)nextLink, serviceContext).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)e))))), f -> ChatMessageReadReceiptConverter.convert(f));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ChatThreadProperties> getProperties() {
        try {
            Objects.requireNonNull(this.chatThreadId, "'chatThreadId' cannot be null.");
            return FluxUtil.withContext(context -> this.getProperties((Context)context).flatMap(res -> {
                if (res.getValue() != null) {
                    return Mono.just((Object)((ChatThreadProperties)res.getValue()));
                }
                return Mono.empty();
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ChatThreadProperties>> getPropertiesWithResponse() {
        try {
            Objects.requireNonNull(this.chatThreadId, "'chatThreadId' cannot be null.");
            return FluxUtil.withContext(context -> this.getProperties((Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ChatThreadProperties>> getProperties(Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.chatThreadClient.getChatThreadPropertiesWithResponseAsync(this.chatThreadId, context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e))).flatMap(res -> Mono.just((Object)new SimpleResponse(res, (Object)ChatThreadPropertiesConverter.convert((com.azure.communication.chat.implementation.models.ChatThreadProperties)res.getValue()))));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private <T1, T2> PagedFlux<T1> pagedFluxConvert(PagedFlux<T2> originalPagedFlux, Function<T2, T1> func) {
        Function<PagedResponse, PagedResponse> responseMapper = response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), response.getValue().stream().map(value -> func.apply(value)).collect(Collectors.toList()), (String)response.getContinuationToken(), null);
        Supplier<PageRetriever> provider = () -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? originalPagedFlux.byPage() : originalPagedFlux.byPage(continuationToken);
            return flux.map(responseMapper);
        };
        return PagedFlux.create(provider);
    }

    private ChatErrorResponseException translateException(CommunicationErrorResponseException exception) {
        ChatError error = null;
        if (exception.getValue() != null) {
            error = ChatErrorConverter.convert(exception.getValue().getError());
        }
        return new ChatErrorResponseException(exception.getMessage(), exception.getResponse(), error);
    }
}

