/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ZohoLinkedService
extends LinkedService {
    private String type = "Zoho";
    private Object connectionProperties;
    private Object endpoint;
    private SecretBase accessToken;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionProperties() {
        return this.connectionProperties;
    }

    public ZohoLinkedService setConnectionProperties(Object connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public Object getEndpoint() {
        return this.endpoint;
    }

    public ZohoLinkedService setEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public SecretBase getAccessToken() {
        return this.accessToken;
    }

    public ZohoLinkedService setAccessToken(SecretBase accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public Object getUseEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public ZohoLinkedService setUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object getUseHostVerification() {
        return this.useHostVerification;
    }

    public ZohoLinkedService setUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object getUsePeerVerification() {
        return this.usePeerVerification;
    }

    public ZohoLinkedService setUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public ZohoLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public ZohoLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public ZohoLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public ZohoLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ZohoLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public ZohoLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionProperties != null || this.endpoint != null || this.accessToken != null || this.useEncryptedEndpoints != null || this.useHostVerification != null || this.usePeerVerification != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.connectionProperties != null) {
                jsonWriter.writeUntypedField("connectionProperties", this.connectionProperties);
            }
            jsonWriter.writeUntypedField("endpoint", this.endpoint);
            jsonWriter.writeJsonField("accessToken", (JsonSerializable)this.accessToken);
            if (this.useEncryptedEndpoints != null) {
                jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
            }
            if (this.useHostVerification != null) {
                jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
            }
            if (this.usePeerVerification != null) {
                jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ZohoLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (ZohoLinkedService)jsonReader.readObject(reader -> {
            ZohoLinkedService deserializedZohoLinkedService = new ZohoLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedZohoLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedZohoLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedZohoLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedZohoLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedZohoLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedZohoLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionProperties".equals(fieldName)) {
                            deserializedZohoLinkedService.connectionProperties = reader.readUntyped();
                            continue;
                        }
                        if ("endpoint".equals(fieldName)) {
                            deserializedZohoLinkedService.endpoint = reader.readUntyped();
                            continue;
                        }
                        if ("accessToken".equals(fieldName)) {
                            deserializedZohoLinkedService.accessToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("useEncryptedEndpoints".equals(fieldName)) {
                            deserializedZohoLinkedService.useEncryptedEndpoints = reader.readUntyped();
                            continue;
                        }
                        if ("useHostVerification".equals(fieldName)) {
                            deserializedZohoLinkedService.useHostVerification = reader.readUntyped();
                            continue;
                        }
                        if ("usePeerVerification".equals(fieldName)) {
                            deserializedZohoLinkedService.usePeerVerification = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedZohoLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedZohoLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedZohoLinkedService;
        });
    }
}

