/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CompressionReadSettings;
import com.azure.analytics.synapse.artifacts.models.FormatReadSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class XmlReadSettings
extends FormatReadSettings {
    private String type = "XmlReadSettings";
    private CompressionReadSettings compressionProperties;
    private Object validationMode;
    private Object detectDataType;
    private Object namespaces;
    private Object namespacePrefixes;

    @Override
    public String getType() {
        return this.type;
    }

    public CompressionReadSettings getCompressionProperties() {
        return this.compressionProperties;
    }

    public XmlReadSettings setCompressionProperties(CompressionReadSettings compressionProperties) {
        this.compressionProperties = compressionProperties;
        return this;
    }

    public Object getValidationMode() {
        return this.validationMode;
    }

    public XmlReadSettings setValidationMode(Object validationMode) {
        this.validationMode = validationMode;
        return this;
    }

    public Object getDetectDataType() {
        return this.detectDataType;
    }

    public XmlReadSettings setDetectDataType(Object detectDataType) {
        this.detectDataType = detectDataType;
        return this;
    }

    public Object getNamespaces() {
        return this.namespaces;
    }

    public XmlReadSettings setNamespaces(Object namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public Object getNamespacePrefixes() {
        return this.namespacePrefixes;
    }

    public XmlReadSettings setNamespacePrefixes(Object namespacePrefixes) {
        this.namespacePrefixes = namespacePrefixes;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("compressionProperties", (JsonSerializable)this.compressionProperties);
        if (this.validationMode != null) {
            jsonWriter.writeUntypedField("validationMode", this.validationMode);
        }
        if (this.detectDataType != null) {
            jsonWriter.writeUntypedField("detectDataType", this.detectDataType);
        }
        if (this.namespaces != null) {
            jsonWriter.writeUntypedField("namespaces", this.namespaces);
        }
        if (this.namespacePrefixes != null) {
            jsonWriter.writeUntypedField("namespacePrefixes", this.namespacePrefixes);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static XmlReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (XmlReadSettings)jsonReader.readObject(reader -> {
            XmlReadSettings deserializedXmlReadSettings = new XmlReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedXmlReadSettings.type = reader.getString();
                    continue;
                }
                if ("compressionProperties".equals(fieldName)) {
                    deserializedXmlReadSettings.compressionProperties = CompressionReadSettings.fromJson(reader);
                    continue;
                }
                if ("validationMode".equals(fieldName)) {
                    deserializedXmlReadSettings.validationMode = reader.readUntyped();
                    continue;
                }
                if ("detectDataType".equals(fieldName)) {
                    deserializedXmlReadSettings.detectDataType = reader.readUntyped();
                    continue;
                }
                if ("namespaces".equals(fieldName)) {
                    deserializedXmlReadSettings.namespaces = reader.readUntyped();
                    continue;
                }
                if ("namespacePrefixes".equals(fieldName)) {
                    deserializedXmlReadSettings.namespacePrefixes = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedXmlReadSettings.setAdditionalProperties(additionalProperties);
            return deserializedXmlReadSettings;
        });
    }
}

