/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ControlActivity;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.analytics.synapse.artifacts.models.WebActivityAuthentication;
import com.azure.analytics.synapse.artifacts.models.WebHookActivityMethod;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WebHookActivity
extends ControlActivity {
    private String type = "WebHook";
    private WebHookActivityMethod method;
    private Object url;
    private String timeout;
    private Object headers;
    private Object body;
    private WebActivityAuthentication authentication;
    private Object reportStatusOnCallBack;

    @Override
    public String getType() {
        return this.type;
    }

    public WebHookActivityMethod getMethod() {
        return this.method;
    }

    public WebHookActivity setMethod(WebHookActivityMethod method) {
        this.method = method;
        return this;
    }

    public Object getUrl() {
        return this.url;
    }

    public WebHookActivity setUrl(Object url) {
        this.url = url;
        return this;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public WebHookActivity setTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    public Object getHeaders() {
        return this.headers;
    }

    public WebHookActivity setHeaders(Object headers) {
        this.headers = headers;
        return this;
    }

    public Object getBody() {
        return this.body;
    }

    public WebHookActivity setBody(Object body) {
        this.body = body;
        return this;
    }

    public WebActivityAuthentication getAuthentication() {
        return this.authentication;
    }

    public WebHookActivity setAuthentication(WebActivityAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public Object getReportStatusOnCallBack() {
        return this.reportStatusOnCallBack;
    }

    public WebHookActivity setReportStatusOnCallBack(Object reportStatusOnCallBack) {
        this.reportStatusOnCallBack = reportStatusOnCallBack;
        return this;
    }

    @Override
    public WebHookActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public WebHookActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public WebHookActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public WebHookActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public WebHookActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public WebHookActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.method != null || this.url != null || this.timeout != null || this.headers != null || this.body != null || this.authentication != null || this.reportStatusOnCallBack != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
            jsonWriter.writeUntypedField("url", this.url);
            jsonWriter.writeStringField("timeout", this.timeout);
            if (this.headers != null) {
                jsonWriter.writeUntypedField("headers", this.headers);
            }
            if (this.body != null) {
                jsonWriter.writeUntypedField("body", this.body);
            }
            jsonWriter.writeJsonField("authentication", (JsonSerializable)this.authentication);
            if (this.reportStatusOnCallBack != null) {
                jsonWriter.writeUntypedField("reportStatusOnCallBack", this.reportStatusOnCallBack);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static WebHookActivity fromJson(JsonReader jsonReader) throws IOException {
        return (WebHookActivity)jsonReader.readObject(reader -> {
            WebHookActivity deserializedWebHookActivity = new WebHookActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedWebHookActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedWebHookActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedWebHookActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedWebHookActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedWebHookActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedWebHookActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWebHookActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("method".equals(fieldName)) {
                            deserializedWebHookActivity.method = WebHookActivityMethod.fromString(reader.getString());
                            continue;
                        }
                        if ("url".equals(fieldName)) {
                            deserializedWebHookActivity.url = reader.readUntyped();
                            continue;
                        }
                        if ("timeout".equals(fieldName)) {
                            deserializedWebHookActivity.timeout = reader.getString();
                            continue;
                        }
                        if ("headers".equals(fieldName)) {
                            deserializedWebHookActivity.headers = reader.readUntyped();
                            continue;
                        }
                        if ("body".equals(fieldName)) {
                            deserializedWebHookActivity.body = reader.readUntyped();
                            continue;
                        }
                        if ("authentication".equals(fieldName)) {
                            deserializedWebHookActivity.authentication = WebActivityAuthentication.fromJson(reader);
                            continue;
                        }
                        if ("reportStatusOnCallBack".equals(fieldName)) {
                            deserializedWebHookActivity.reportStatusOnCallBack = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedWebHookActivity.setAdditionalProperties(additionalProperties);
            return deserializedWebHookActivity;
        });
    }
}

