/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class WebActivityAuthentication
implements JsonSerializable<WebActivityAuthentication> {
    private String type;
    private SecretBase pfx;
    private Object username;
    private SecretBase password;
    private Object resource;
    private Object userTenant;
    private CredentialReference credential;

    public String getType() {
        return this.type;
    }

    public WebActivityAuthentication setType(String type) {
        this.type = type;
        return this;
    }

    public SecretBase getPfx() {
        return this.pfx;
    }

    public WebActivityAuthentication setPfx(SecretBase pfx) {
        this.pfx = pfx;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public WebActivityAuthentication setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public WebActivityAuthentication setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getResource() {
        return this.resource;
    }

    public WebActivityAuthentication setResource(Object resource) {
        this.resource = resource;
        return this;
    }

    public Object getUserTenant() {
        return this.userTenant;
    }

    public WebActivityAuthentication setUserTenant(Object userTenant) {
        this.userTenant = userTenant;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public WebActivityAuthentication setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("pfx", (JsonSerializable)this.pfx);
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.resource != null) {
            jsonWriter.writeUntypedField("resource", this.resource);
        }
        if (this.userTenant != null) {
            jsonWriter.writeUntypedField("userTenant", this.userTenant);
        }
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static WebActivityAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (WebActivityAuthentication)jsonReader.readObject(reader -> {
            WebActivityAuthentication deserializedWebActivityAuthentication = new WebActivityAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedWebActivityAuthentication.type = reader.getString();
                    continue;
                }
                if ("pfx".equals(fieldName)) {
                    deserializedWebActivityAuthentication.pfx = SecretBase.fromJson(reader);
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedWebActivityAuthentication.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedWebActivityAuthentication.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("resource".equals(fieldName)) {
                    deserializedWebActivityAuthentication.resource = reader.readUntyped();
                    continue;
                }
                if ("userTenant".equals(fieldName)) {
                    deserializedWebActivityAuthentication.userTenant = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedWebActivityAuthentication.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebActivityAuthentication;
        });
    }
}

