/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.TabularSource;
import com.azure.analytics.synapse.artifacts.models.TeradataPartitionOption;
import com.azure.analytics.synapse.artifacts.models.TeradataPartitionSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TeradataSource
extends TabularSource {
    private String type = "TeradataSource";
    private Object query;
    private TeradataPartitionOption partitionOption;
    private TeradataPartitionSettings partitionSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getQuery() {
        return this.query;
    }

    public TeradataSource setQuery(Object query) {
        this.query = query;
        return this;
    }

    public TeradataPartitionOption getPartitionOption() {
        return this.partitionOption;
    }

    public TeradataSource setPartitionOption(TeradataPartitionOption partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public TeradataPartitionSettings getPartitionSettings() {
        return this.partitionSettings;
    }

    public TeradataSource setPartitionSettings(TeradataPartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    @Override
    public TeradataSource setQueryTimeout(Object queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public TeradataSource setAdditionalColumns(Object additionalColumns) {
        super.setAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public TeradataSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public TeradataSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public TeradataSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getQueryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.getQueryTimeout());
        }
        if (this.getAdditionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.getAdditionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        jsonWriter.writeStringField("partitionOption", this.partitionOption == null ? null : this.partitionOption.toString());
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TeradataSource fromJson(JsonReader jsonReader) throws IOException {
        return (TeradataSource)jsonReader.readObject(reader -> {
            TeradataSource deserializedTeradataSource = new TeradataSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedTeradataSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedTeradataSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedTeradataSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedTeradataSource.setQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedTeradataSource.setAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTeradataSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedTeradataSource.query = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedTeradataSource.partitionOption = TeradataPartitionOption.fromString(reader.getString());
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedTeradataSource.partitionSettings = TeradataPartitionSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTeradataSource.setAdditionalProperties(additionalProperties);
            return deserializedTeradataSource;
        });
    }
}

