/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.BigDataPoolParametrizationReference;
import com.azure.analytics.synapse.artifacts.models.ConfigurationType;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.SparkConfigurationParametrizationReference;
import com.azure.analytics.synapse.artifacts.models.SynapseActivityAuthentication;
import com.azure.analytics.synapse.artifacts.models.SynapseSparkJobReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SynapseSparkJobDefinitionActivity
extends ExecutionActivity {
    private String type = "SparkJob";
    private SynapseSparkJobReference sparkJob;
    private List<Object> arguments;
    private Object file;
    private Object scanFolder;
    private Object className;
    private List<Object> files;
    private List<Object> pythonCodeReference;
    private List<Object> filesV2;
    private BigDataPoolParametrizationReference targetBigDataPool;
    private Object executorSize;
    private Object conf;
    private Object driverSize;
    private Object numExecutors;
    private ConfigurationType configurationType;
    private SparkConfigurationParametrizationReference targetSparkConfiguration;
    private Map<String, Object> sparkConfig;
    private SynapseActivityAuthentication authentication;

    @Override
    public String getType() {
        return this.type;
    }

    public SynapseSparkJobReference getSparkJob() {
        return this.sparkJob;
    }

    public SynapseSparkJobDefinitionActivity setSparkJob(SynapseSparkJobReference sparkJob) {
        this.sparkJob = sparkJob;
        return this;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public SynapseSparkJobDefinitionActivity setArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public Object getFile() {
        return this.file;
    }

    public SynapseSparkJobDefinitionActivity setFile(Object file) {
        this.file = file;
        return this;
    }

    public Object getScanFolder() {
        return this.scanFolder;
    }

    public SynapseSparkJobDefinitionActivity setScanFolder(Object scanFolder) {
        this.scanFolder = scanFolder;
        return this;
    }

    public Object getClassName() {
        return this.className;
    }

    public SynapseSparkJobDefinitionActivity setClassName(Object className) {
        this.className = className;
        return this;
    }

    public List<Object> getFiles() {
        return this.files;
    }

    public SynapseSparkJobDefinitionActivity setFiles(List<Object> files) {
        this.files = files;
        return this;
    }

    public List<Object> getPythonCodeReference() {
        return this.pythonCodeReference;
    }

    public SynapseSparkJobDefinitionActivity setPythonCodeReference(List<Object> pythonCodeReference) {
        this.pythonCodeReference = pythonCodeReference;
        return this;
    }

    public List<Object> getFilesV2() {
        return this.filesV2;
    }

    public SynapseSparkJobDefinitionActivity setFilesV2(List<Object> filesV2) {
        this.filesV2 = filesV2;
        return this;
    }

    public BigDataPoolParametrizationReference getTargetBigDataPool() {
        return this.targetBigDataPool;
    }

    public SynapseSparkJobDefinitionActivity setTargetBigDataPool(BigDataPoolParametrizationReference targetBigDataPool) {
        this.targetBigDataPool = targetBigDataPool;
        return this;
    }

    public Object getExecutorSize() {
        return this.executorSize;
    }

    public SynapseSparkJobDefinitionActivity setExecutorSize(Object executorSize) {
        this.executorSize = executorSize;
        return this;
    }

    public Object getConf() {
        return this.conf;
    }

    public SynapseSparkJobDefinitionActivity setConf(Object conf) {
        this.conf = conf;
        return this;
    }

    public Object getDriverSize() {
        return this.driverSize;
    }

    public SynapseSparkJobDefinitionActivity setDriverSize(Object driverSize) {
        this.driverSize = driverSize;
        return this;
    }

    public Object getNumExecutors() {
        return this.numExecutors;
    }

    public SynapseSparkJobDefinitionActivity setNumExecutors(Object numExecutors) {
        this.numExecutors = numExecutors;
        return this;
    }

    public ConfigurationType getConfigurationType() {
        return this.configurationType;
    }

    public SynapseSparkJobDefinitionActivity setConfigurationType(ConfigurationType configurationType) {
        this.configurationType = configurationType;
        return this;
    }

    public SparkConfigurationParametrizationReference getTargetSparkConfiguration() {
        return this.targetSparkConfiguration;
    }

    public SynapseSparkJobDefinitionActivity setTargetSparkConfiguration(SparkConfigurationParametrizationReference targetSparkConfiguration) {
        this.targetSparkConfiguration = targetSparkConfiguration;
        return this;
    }

    public Map<String, Object> getSparkConfig() {
        return this.sparkConfig;
    }

    public SynapseSparkJobDefinitionActivity setSparkConfig(Map<String, Object> sparkConfig) {
        this.sparkConfig = sparkConfig;
        return this;
    }

    public SynapseActivityAuthentication getAuthentication() {
        return this.authentication;
    }

    public SynapseSparkJobDefinitionActivity setAuthentication(SynapseActivityAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.sparkJob != null || this.arguments != null || this.file != null || this.scanFolder != null || this.className != null || this.files != null || this.pythonCodeReference != null || this.filesV2 != null || this.targetBigDataPool != null || this.executorSize != null || this.conf != null || this.driverSize != null || this.numExecutors != null || this.configurationType != null || this.targetSparkConfiguration != null || this.sparkConfig != null || this.authentication != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("sparkJob", (JsonSerializable)this.sparkJob);
            jsonWriter.writeArrayField("args", this.arguments, (writer, element) -> writer.writeUntyped(element));
            if (this.file != null) {
                jsonWriter.writeUntypedField("file", this.file);
            }
            if (this.scanFolder != null) {
                jsonWriter.writeUntypedField("scanFolder", this.scanFolder);
            }
            if (this.className != null) {
                jsonWriter.writeUntypedField("className", this.className);
            }
            jsonWriter.writeArrayField("files", this.files, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeArrayField("pythonCodeReference", this.pythonCodeReference, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeArrayField("filesV2", this.filesV2, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeJsonField("targetBigDataPool", (JsonSerializable)this.targetBigDataPool);
            if (this.executorSize != null) {
                jsonWriter.writeUntypedField("executorSize", this.executorSize);
            }
            if (this.conf != null) {
                jsonWriter.writeUntypedField("conf", this.conf);
            }
            if (this.driverSize != null) {
                jsonWriter.writeUntypedField("driverSize", this.driverSize);
            }
            if (this.numExecutors != null) {
                jsonWriter.writeUntypedField("numExecutors", this.numExecutors);
            }
            jsonWriter.writeStringField("configurationType", this.configurationType == null ? null : this.configurationType.toString());
            jsonWriter.writeJsonField("targetSparkConfiguration", (JsonSerializable)this.targetSparkConfiguration);
            jsonWriter.writeMapField("sparkConfig", this.sparkConfig, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeJsonField("authentication", (JsonSerializable)this.authentication);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SynapseSparkJobDefinitionActivity fromJson(JsonReader jsonReader) throws IOException {
        return (SynapseSparkJobDefinitionActivity)jsonReader.readObject(reader -> {
            SynapseSparkJobDefinitionActivity deserializedSynapseSparkJobDefinitionActivity = new SynapseSparkJobDefinitionActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedSynapseSparkJobDefinitionActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedSynapseSparkJobDefinitionActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("sparkJob".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.sparkJob = SynapseSparkJobReference.fromJson(reader);
                            continue;
                        }
                        if ("args".equals(fieldName)) {
                            List arguments;
                            deserializedSynapseSparkJobDefinitionActivity.arguments = arguments = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("file".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.file = reader.readUntyped();
                            continue;
                        }
                        if ("scanFolder".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.scanFolder = reader.readUntyped();
                            continue;
                        }
                        if ("className".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.className = reader.readUntyped();
                            continue;
                        }
                        if ("files".equals(fieldName)) {
                            List files;
                            deserializedSynapseSparkJobDefinitionActivity.files = files = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("pythonCodeReference".equals(fieldName)) {
                            List pythonCodeReference;
                            deserializedSynapseSparkJobDefinitionActivity.pythonCodeReference = pythonCodeReference = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("filesV2".equals(fieldName)) {
                            List filesV2;
                            deserializedSynapseSparkJobDefinitionActivity.filesV2 = filesV2 = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("targetBigDataPool".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.targetBigDataPool = BigDataPoolParametrizationReference.fromJson(reader);
                            continue;
                        }
                        if ("executorSize".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.executorSize = reader.readUntyped();
                            continue;
                        }
                        if ("conf".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.conf = reader.readUntyped();
                            continue;
                        }
                        if ("driverSize".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.driverSize = reader.readUntyped();
                            continue;
                        }
                        if ("numExecutors".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.numExecutors = reader.readUntyped();
                            continue;
                        }
                        if ("configurationType".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.configurationType = ConfigurationType.fromString(reader.getString());
                            continue;
                        }
                        if ("targetSparkConfiguration".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.targetSparkConfiguration = SparkConfigurationParametrizationReference.fromJson(reader);
                            continue;
                        }
                        if ("sparkConfig".equals(fieldName)) {
                            Map sparkConfig;
                            deserializedSynapseSparkJobDefinitionActivity.sparkConfig = sparkConfig = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("authentication".equals(fieldName)) {
                            deserializedSynapseSparkJobDefinitionActivity.authentication = SynapseActivityAuthentication.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSynapseSparkJobDefinitionActivity.setAdditionalProperties(additionalProperties);
            return deserializedSynapseSparkJobDefinitionActivity;
        });
    }
}

