/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.BigDataPoolParametrizationReference;
import com.azure.analytics.synapse.artifacts.models.ConfigurationType;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.NotebookParameter;
import com.azure.analytics.synapse.artifacts.models.SparkConfigurationParametrizationReference;
import com.azure.analytics.synapse.artifacts.models.SynapseActivityAuthentication;
import com.azure.analytics.synapse.artifacts.models.SynapseNotebookReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SynapseNotebookActivity
extends ExecutionActivity {
    private String type = "SynapseNotebook";
    private SynapseNotebookReference notebook;
    private BigDataPoolParametrizationReference sparkPool;
    private Map<String, NotebookParameter> parameters;
    private Object executorSize;
    private Object conf;
    private Object driverSize;
    private Object numExecutors;
    private ConfigurationType configurationType;
    private SparkConfigurationParametrizationReference targetSparkConfiguration;
    private Map<String, Object> sparkConfig;
    private SynapseActivityAuthentication authentication;

    @Override
    public String getType() {
        return this.type;
    }

    public SynapseNotebookReference getNotebook() {
        return this.notebook;
    }

    public SynapseNotebookActivity setNotebook(SynapseNotebookReference notebook) {
        this.notebook = notebook;
        return this;
    }

    public BigDataPoolParametrizationReference getSparkPool() {
        return this.sparkPool;
    }

    public SynapseNotebookActivity setSparkPool(BigDataPoolParametrizationReference sparkPool) {
        this.sparkPool = sparkPool;
        return this;
    }

    public Map<String, NotebookParameter> getParameters() {
        return this.parameters;
    }

    public SynapseNotebookActivity setParameters(Map<String, NotebookParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Object getExecutorSize() {
        return this.executorSize;
    }

    public SynapseNotebookActivity setExecutorSize(Object executorSize) {
        this.executorSize = executorSize;
        return this;
    }

    public Object getConf() {
        return this.conf;
    }

    public SynapseNotebookActivity setConf(Object conf) {
        this.conf = conf;
        return this;
    }

    public Object getDriverSize() {
        return this.driverSize;
    }

    public SynapseNotebookActivity setDriverSize(Object driverSize) {
        this.driverSize = driverSize;
        return this;
    }

    public Object getNumExecutors() {
        return this.numExecutors;
    }

    public SynapseNotebookActivity setNumExecutors(Object numExecutors) {
        this.numExecutors = numExecutors;
        return this;
    }

    public ConfigurationType getConfigurationType() {
        return this.configurationType;
    }

    public SynapseNotebookActivity setConfigurationType(ConfigurationType configurationType) {
        this.configurationType = configurationType;
        return this;
    }

    public SparkConfigurationParametrizationReference getTargetSparkConfiguration() {
        return this.targetSparkConfiguration;
    }

    public SynapseNotebookActivity setTargetSparkConfiguration(SparkConfigurationParametrizationReference targetSparkConfiguration) {
        this.targetSparkConfiguration = targetSparkConfiguration;
        return this;
    }

    public Map<String, Object> getSparkConfig() {
        return this.sparkConfig;
    }

    public SynapseNotebookActivity setSparkConfig(Map<String, Object> sparkConfig) {
        this.sparkConfig = sparkConfig;
        return this;
    }

    public SynapseActivityAuthentication getAuthentication() {
        return this.authentication;
    }

    public SynapseNotebookActivity setAuthentication(SynapseActivityAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    @Override
    public SynapseNotebookActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SynapseNotebookActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public SynapseNotebookActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public SynapseNotebookActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SynapseNotebookActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public SynapseNotebookActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public SynapseNotebookActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public SynapseNotebookActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.notebook != null || this.sparkPool != null || this.parameters != null || this.executorSize != null || this.conf != null || this.driverSize != null || this.numExecutors != null || this.configurationType != null || this.targetSparkConfiguration != null || this.sparkConfig != null || this.authentication != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("notebook", (JsonSerializable)this.notebook);
            jsonWriter.writeJsonField("sparkPool", (JsonSerializable)this.sparkPool);
            jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
            if (this.executorSize != null) {
                jsonWriter.writeUntypedField("executorSize", this.executorSize);
            }
            if (this.conf != null) {
                jsonWriter.writeUntypedField("conf", this.conf);
            }
            if (this.driverSize != null) {
                jsonWriter.writeUntypedField("driverSize", this.driverSize);
            }
            if (this.numExecutors != null) {
                jsonWriter.writeUntypedField("numExecutors", this.numExecutors);
            }
            jsonWriter.writeStringField("configurationType", this.configurationType == null ? null : this.configurationType.toString());
            jsonWriter.writeJsonField("targetSparkConfiguration", (JsonSerializable)this.targetSparkConfiguration);
            jsonWriter.writeMapField("sparkConfig", this.sparkConfig, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeJsonField("authentication", (JsonSerializable)this.authentication);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SynapseNotebookActivity fromJson(JsonReader jsonReader) throws IOException {
        return (SynapseNotebookActivity)jsonReader.readObject(reader -> {
            SynapseNotebookActivity deserializedSynapseNotebookActivity = new SynapseNotebookActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSynapseNotebookActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSynapseNotebookActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSynapseNotebookActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedSynapseNotebookActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedSynapseNotebookActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedSynapseNotebookActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedSynapseNotebookActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedSynapseNotebookActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSynapseNotebookActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("notebook".equals(fieldName)) {
                            deserializedSynapseNotebookActivity.notebook = SynapseNotebookReference.fromJson(reader);
                            continue;
                        }
                        if ("sparkPool".equals(fieldName)) {
                            deserializedSynapseNotebookActivity.sparkPool = BigDataPoolParametrizationReference.fromJson(reader);
                            continue;
                        }
                        if ("parameters".equals(fieldName)) {
                            Map parameters;
                            deserializedSynapseNotebookActivity.parameters = parameters = reader.readMap(reader1 -> NotebookParameter.fromJson(reader1));
                            continue;
                        }
                        if ("executorSize".equals(fieldName)) {
                            deserializedSynapseNotebookActivity.executorSize = reader.readUntyped();
                            continue;
                        }
                        if ("conf".equals(fieldName)) {
                            deserializedSynapseNotebookActivity.conf = reader.readUntyped();
                            continue;
                        }
                        if ("driverSize".equals(fieldName)) {
                            deserializedSynapseNotebookActivity.driverSize = reader.readUntyped();
                            continue;
                        }
                        if ("numExecutors".equals(fieldName)) {
                            deserializedSynapseNotebookActivity.numExecutors = reader.readUntyped();
                            continue;
                        }
                        if ("configurationType".equals(fieldName)) {
                            deserializedSynapseNotebookActivity.configurationType = ConfigurationType.fromString(reader.getString());
                            continue;
                        }
                        if ("targetSparkConfiguration".equals(fieldName)) {
                            deserializedSynapseNotebookActivity.targetSparkConfiguration = SparkConfigurationParametrizationReference.fromJson(reader);
                            continue;
                        }
                        if ("sparkConfig".equals(fieldName)) {
                            Map sparkConfig;
                            deserializedSynapseNotebookActivity.sparkConfig = sparkConfig = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("authentication".equals(fieldName)) {
                            deserializedSynapseNotebookActivity.authentication = SynapseActivityAuthentication.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSynapseNotebookActivity.setAdditionalProperties(additionalProperties);
            return deserializedSynapseNotebookActivity;
        });
    }
}

