/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AmazonS3ReadSettings;
import com.azure.analytics.synapse.artifacts.models.AzureBlobFSReadSettings;
import com.azure.analytics.synapse.artifacts.models.AzureBlobStorageReadSettings;
import com.azure.analytics.synapse.artifacts.models.AzureDataLakeStoreReadSettings;
import com.azure.analytics.synapse.artifacts.models.AzureFileStorageReadSettings;
import com.azure.analytics.synapse.artifacts.models.FileServerReadSettings;
import com.azure.analytics.synapse.artifacts.models.FtpReadSettings;
import com.azure.analytics.synapse.artifacts.models.GoogleCloudStorageReadSettings;
import com.azure.analytics.synapse.artifacts.models.HdfsReadSettings;
import com.azure.analytics.synapse.artifacts.models.HttpReadSettings;
import com.azure.analytics.synapse.artifacts.models.LakeHouseReadSettings;
import com.azure.analytics.synapse.artifacts.models.SftpReadSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class StoreReadSettings
implements JsonSerializable<StoreReadSettings> {
    private String type = "StoreReadSettings";
    private Object maxConcurrentConnections;
    private Map<String, Object> additionalProperties;

    public String getType() {
        return this.type;
    }

    public Object getMaxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    public StoreReadSettings setMaxConcurrentConnections(Object maxConcurrentConnections) {
        this.maxConcurrentConnections = maxConcurrentConnections;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public StoreReadSettings setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        if (this.maxConcurrentConnections != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections);
        }
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static StoreReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (StoreReadSettings)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                StoreReadSettings storeReadSettings;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("AzureBlobStorageReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = AzureBlobStorageReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("AzureBlobFSReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = AzureBlobFSReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("AzureDataLakeStoreReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = AzureDataLakeStoreReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("AmazonS3ReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = AmazonS3ReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("FileServerReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = FileServerReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("AzureFileStorageReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = AzureFileStorageReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("GoogleCloudStorageReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = GoogleCloudStorageReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("FtpReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = FtpReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("SftpReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = SftpReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("HttpReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = HttpReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("HdfsReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = HdfsReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                if ("LakeHouseReadSettings".equals(discriminatorValue)) {
                    storeReadSettings = LakeHouseReadSettings.fromJson(readerToUse.reset());
                    return storeReadSettings;
                }
                storeReadSettings = StoreReadSettings.fromJsonKnownDiscriminator(readerToUse.reset());
                return storeReadSettings;
            }
        });
    }

    static StoreReadSettings fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (StoreReadSettings)jsonReader.readObject(reader -> {
            StoreReadSettings deserializedStoreReadSettings = new StoreReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedStoreReadSettings.type = reader.getString();
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedStoreReadSettings.maxConcurrentConnections = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedStoreReadSettings.additionalProperties = additionalProperties;
            return deserializedStoreReadSettings;
        });
    }
}

