/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySink;
import com.azure.analytics.synapse.artifacts.models.DWCopyCommandSettings;
import com.azure.analytics.synapse.artifacts.models.PolybaseSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SqlDWSink
extends CopySink {
    private String type = "SqlDWSink";
    private Object preCopyScript;
    private Object allowPolyBase;
    private PolybaseSettings polyBaseSettings;
    private Object allowCopyCommand;
    private DWCopyCommandSettings copyCommandSettings;
    private Object tableOption;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getPreCopyScript() {
        return this.preCopyScript;
    }

    public SqlDWSink setPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public Object getAllowPolyBase() {
        return this.allowPolyBase;
    }

    public SqlDWSink setAllowPolyBase(Object allowPolyBase) {
        this.allowPolyBase = allowPolyBase;
        return this;
    }

    public PolybaseSettings getPolyBaseSettings() {
        return this.polyBaseSettings;
    }

    public SqlDWSink setPolyBaseSettings(PolybaseSettings polyBaseSettings) {
        this.polyBaseSettings = polyBaseSettings;
        return this;
    }

    public Object getAllowCopyCommand() {
        return this.allowCopyCommand;
    }

    public SqlDWSink setAllowCopyCommand(Object allowCopyCommand) {
        this.allowCopyCommand = allowCopyCommand;
        return this;
    }

    public DWCopyCommandSettings getCopyCommandSettings() {
        return this.copyCommandSettings;
    }

    public SqlDWSink setCopyCommandSettings(DWCopyCommandSettings copyCommandSettings) {
        this.copyCommandSettings = copyCommandSettings;
        return this;
    }

    public Object getTableOption() {
        return this.tableOption;
    }

    public SqlDWSink setTableOption(Object tableOption) {
        this.tableOption = tableOption;
        return this;
    }

    @Override
    public SqlDWSink setWriteBatchSize(Object writeBatchSize) {
        super.setWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public SqlDWSink setWriteBatchTimeout(Object writeBatchTimeout) {
        super.setWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public SqlDWSink setSinkRetryCount(Object sinkRetryCount) {
        super.setSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public SqlDWSink setSinkRetryWait(Object sinkRetryWait) {
        super.setSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public SqlDWSink setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getWriteBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.getWriteBatchSize());
        }
        if (this.getWriteBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.getWriteBatchTimeout());
        }
        if (this.getSinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.getSinkRetryCount());
        }
        if (this.getSinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.getSinkRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.preCopyScript != null) {
            jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        }
        if (this.allowPolyBase != null) {
            jsonWriter.writeUntypedField("allowPolyBase", this.allowPolyBase);
        }
        jsonWriter.writeJsonField("polyBaseSettings", (JsonSerializable)this.polyBaseSettings);
        if (this.allowCopyCommand != null) {
            jsonWriter.writeUntypedField("allowCopyCommand", this.allowCopyCommand);
        }
        jsonWriter.writeJsonField("copyCommandSettings", (JsonSerializable)this.copyCommandSettings);
        if (this.tableOption != null) {
            jsonWriter.writeUntypedField("tableOption", this.tableOption);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlDWSink fromJson(JsonReader jsonReader) throws IOException {
        return (SqlDWSink)jsonReader.readObject(reader -> {
            SqlDWSink deserializedSqlDWSink = new SqlDWSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedSqlDWSink.setWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedSqlDWSink.setWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedSqlDWSink.setSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedSqlDWSink.setSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSqlDWSink.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlDWSink.type = reader.getString();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedSqlDWSink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("allowPolyBase".equals(fieldName)) {
                    deserializedSqlDWSink.allowPolyBase = reader.readUntyped();
                    continue;
                }
                if ("polyBaseSettings".equals(fieldName)) {
                    deserializedSqlDWSink.polyBaseSettings = PolybaseSettings.fromJson(reader);
                    continue;
                }
                if ("allowCopyCommand".equals(fieldName)) {
                    deserializedSqlDWSink.allowCopyCommand = reader.readUntyped();
                    continue;
                }
                if ("copyCommandSettings".equals(fieldName)) {
                    deserializedSqlDWSink.copyCommandSettings = DWCopyCommandSettings.fromJson(reader);
                    continue;
                }
                if ("tableOption".equals(fieldName)) {
                    deserializedSqlDWSink.tableOption = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlDWSink.setAdditionalProperties(additionalProperties);
            return deserializedSqlDWSink;
        });
    }
}

