/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.LivyStates;
import com.azure.analytics.synapse.artifacts.models.SparkBatchJobResultType;
import com.azure.analytics.synapse.artifacts.models.SparkBatchJobState;
import com.azure.analytics.synapse.artifacts.models.SparkJobType;
import com.azure.analytics.synapse.artifacts.models.SparkScheduler;
import com.azure.analytics.synapse.artifacts.models.SparkServiceError;
import com.azure.analytics.synapse.artifacts.models.SparkServicePlugin;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class SparkBatchJob
implements JsonSerializable<SparkBatchJob> {
    private SparkBatchJobState livyInfo;
    private String name;
    private String workspaceName;
    private String sparkPoolName;
    private String submitterName;
    private String submitterId;
    private String artifactId;
    private SparkJobType jobType;
    private SparkBatchJobResultType result;
    private SparkScheduler scheduler;
    private SparkServicePlugin plugin;
    private List<SparkServiceError> errors;
    private Map<String, String> tags;
    private int id;
    private String appId;
    private Map<String, String> appInfo;
    private LivyStates state;
    private List<String> logLines;

    public SparkBatchJobState getLivyInfo() {
        return this.livyInfo;
    }

    public SparkBatchJob setLivyInfo(SparkBatchJobState livyInfo) {
        this.livyInfo = livyInfo;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public SparkBatchJob setName(String name) {
        this.name = name;
        return this;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public SparkBatchJob setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
        return this;
    }

    public String getSparkPoolName() {
        return this.sparkPoolName;
    }

    public SparkBatchJob setSparkPoolName(String sparkPoolName) {
        this.sparkPoolName = sparkPoolName;
        return this;
    }

    public String getSubmitterName() {
        return this.submitterName;
    }

    public SparkBatchJob setSubmitterName(String submitterName) {
        this.submitterName = submitterName;
        return this;
    }

    public String getSubmitterId() {
        return this.submitterId;
    }

    public SparkBatchJob setSubmitterId(String submitterId) {
        this.submitterId = submitterId;
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public SparkBatchJob setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public SparkJobType getJobType() {
        return this.jobType;
    }

    public SparkBatchJob setJobType(SparkJobType jobType) {
        this.jobType = jobType;
        return this;
    }

    public SparkBatchJobResultType getResult() {
        return this.result;
    }

    public SparkBatchJob setResult(SparkBatchJobResultType result) {
        this.result = result;
        return this;
    }

    public SparkScheduler getScheduler() {
        return this.scheduler;
    }

    public SparkBatchJob setScheduler(SparkScheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public SparkServicePlugin getPlugin() {
        return this.plugin;
    }

    public SparkBatchJob setPlugin(SparkServicePlugin plugin) {
        this.plugin = plugin;
        return this;
    }

    public List<SparkServiceError> getErrors() {
        return this.errors;
    }

    public SparkBatchJob setErrors(List<SparkServiceError> errors) {
        this.errors = errors;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public SparkBatchJob setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public SparkBatchJob setId(int id) {
        this.id = id;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public SparkBatchJob setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public Map<String, String> getAppInfo() {
        return this.appInfo;
    }

    public SparkBatchJob setAppInfo(Map<String, String> appInfo) {
        this.appInfo = appInfo;
        return this;
    }

    public LivyStates getState() {
        return this.state;
    }

    public SparkBatchJob setState(LivyStates state) {
        this.state = state;
        return this;
    }

    public List<String> getLogLines() {
        return this.logLines;
    }

    public SparkBatchJob setLogLines(List<String> logLines) {
        this.logLines = logLines;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.id);
        jsonWriter.writeJsonField("livyInfo", (JsonSerializable)this.livyInfo);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("workspaceName", this.workspaceName);
        jsonWriter.writeStringField("sparkPoolName", this.sparkPoolName);
        jsonWriter.writeStringField("submitterName", this.submitterName);
        jsonWriter.writeStringField("submitterId", this.submitterId);
        jsonWriter.writeStringField("artifactId", this.artifactId);
        jsonWriter.writeStringField("jobType", this.jobType == null ? null : this.jobType.toString());
        jsonWriter.writeStringField("result", this.result == null ? null : this.result.toString());
        jsonWriter.writeJsonField("schedulerInfo", (JsonSerializable)this.scheduler);
        jsonWriter.writeJsonField("pluginInfo", (JsonSerializable)this.plugin);
        jsonWriter.writeArrayField("errorInfo", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("appId", this.appId);
        jsonWriter.writeMapField("appInfo", this.appInfo, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("log", this.logLines, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SparkBatchJob fromJson(JsonReader jsonReader) throws IOException {
        return (SparkBatchJob)jsonReader.readObject(reader -> {
            SparkBatchJob deserializedSparkBatchJob = new SparkBatchJob();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSparkBatchJob.id = reader.getInt();
                    continue;
                }
                if ("livyInfo".equals(fieldName)) {
                    deserializedSparkBatchJob.livyInfo = SparkBatchJobState.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSparkBatchJob.name = reader.getString();
                    continue;
                }
                if ("workspaceName".equals(fieldName)) {
                    deserializedSparkBatchJob.workspaceName = reader.getString();
                    continue;
                }
                if ("sparkPoolName".equals(fieldName)) {
                    deserializedSparkBatchJob.sparkPoolName = reader.getString();
                    continue;
                }
                if ("submitterName".equals(fieldName)) {
                    deserializedSparkBatchJob.submitterName = reader.getString();
                    continue;
                }
                if ("submitterId".equals(fieldName)) {
                    deserializedSparkBatchJob.submitterId = reader.getString();
                    continue;
                }
                if ("artifactId".equals(fieldName)) {
                    deserializedSparkBatchJob.artifactId = reader.getString();
                    continue;
                }
                if ("jobType".equals(fieldName)) {
                    deserializedSparkBatchJob.jobType = SparkJobType.fromString(reader.getString());
                    continue;
                }
                if ("result".equals(fieldName)) {
                    deserializedSparkBatchJob.result = SparkBatchJobResultType.fromString(reader.getString());
                    continue;
                }
                if ("schedulerInfo".equals(fieldName)) {
                    deserializedSparkBatchJob.scheduler = SparkScheduler.fromJson(reader);
                    continue;
                }
                if ("pluginInfo".equals(fieldName)) {
                    deserializedSparkBatchJob.plugin = SparkServicePlugin.fromJson(reader);
                    continue;
                }
                if ("errorInfo".equals(fieldName)) {
                    List errors;
                    deserializedSparkBatchJob.errors = errors = reader.readArray(reader1 -> SparkServiceError.fromJson(reader1));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSparkBatchJob.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("appId".equals(fieldName)) {
                    deserializedSparkBatchJob.appId = reader.getString();
                    continue;
                }
                if ("appInfo".equals(fieldName)) {
                    Map appInfo;
                    deserializedSparkBatchJob.appInfo = appInfo = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSparkBatchJob.state = LivyStates.fromString(reader.getString());
                    continue;
                }
                if ("log".equals(fieldName)) {
                    List logLines;
                    deserializedSparkBatchJob.logLines = logLines = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSparkBatchJob;
        });
    }
}

