/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.analytics.synapse.artifacts.models.SnowflakeExportCopyCommand;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SnowflakeV2Source
extends CopySource {
    private String type = "SnowflakeV2Source";
    private Object query;
    private SnowflakeExportCopyCommand exportSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getQuery() {
        return this.query;
    }

    public SnowflakeV2Source setQuery(Object query) {
        this.query = query;
        return this;
    }

    public SnowflakeExportCopyCommand getExportSettings() {
        return this.exportSettings;
    }

    public SnowflakeV2Source setExportSettings(SnowflakeExportCopyCommand exportSettings) {
        this.exportSettings = exportSettings;
        return this;
    }

    @Override
    public SnowflakeV2Source setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SnowflakeV2Source setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SnowflakeV2Source setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeJsonField("exportSettings", (JsonSerializable)this.exportSettings);
        jsonWriter.writeStringField("type", this.type);
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SnowflakeV2Source fromJson(JsonReader jsonReader) throws IOException {
        return (SnowflakeV2Source)jsonReader.readObject(reader -> {
            SnowflakeV2Source deserializedSnowflakeV2Source = new SnowflakeV2Source();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSnowflakeV2Source.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSnowflakeV2Source.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSnowflakeV2Source.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("exportSettings".equals(fieldName)) {
                    deserializedSnowflakeV2Source.exportSettings = SnowflakeExportCopyCommand.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnowflakeV2Source.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedSnowflakeV2Source.query = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSnowflakeV2Source.setAdditionalProperties(additionalProperties);
            return deserializedSnowflakeV2Source;
        });
    }
}

