/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.ServiceNowAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ServiceNowLinkedService
extends LinkedService {
    private String type = "ServiceNow";
    private Object endpoint;
    private ServiceNowAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object clientId;
    private SecretBase clientSecret;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getEndpoint() {
        return this.endpoint;
    }

    public ServiceNowLinkedService setEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ServiceNowAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public ServiceNowLinkedService setAuthenticationType(ServiceNowAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public ServiceNowLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public ServiceNowLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public ServiceNowLinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase getClientSecret() {
        return this.clientSecret;
    }

    public ServiceNowLinkedService setClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object getUseEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public ServiceNowLinkedService setUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object getUseHostVerification() {
        return this.useHostVerification;
    }

    public ServiceNowLinkedService setUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object getUsePeerVerification() {
        return this.usePeerVerification;
    }

    public ServiceNowLinkedService setUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public ServiceNowLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public ServiceNowLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public ServiceNowLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public ServiceNowLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ServiceNowLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public ServiceNowLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.endpoint != null || this.authenticationType != null || this.username != null || this.password != null || this.clientId != null || this.clientSecret != null || this.useEncryptedEndpoints != null || this.useHostVerification != null || this.usePeerVerification != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("endpoint", this.endpoint);
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.clientId != null) {
                jsonWriter.writeUntypedField("clientId", this.clientId);
            }
            jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
            if (this.useEncryptedEndpoints != null) {
                jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
            }
            if (this.useHostVerification != null) {
                jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
            }
            if (this.usePeerVerification != null) {
                jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ServiceNowLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceNowLinkedService)jsonReader.readObject(reader -> {
            ServiceNowLinkedService deserializedServiceNowLinkedService = new ServiceNowLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedServiceNowLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedServiceNowLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedServiceNowLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedServiceNowLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedServiceNowLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServiceNowLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("endpoint".equals(fieldName)) {
                            deserializedServiceNowLinkedService.endpoint = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedServiceNowLinkedService.authenticationType = ServiceNowAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedServiceNowLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedServiceNowLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedServiceNowLinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("clientSecret".equals(fieldName)) {
                            deserializedServiceNowLinkedService.clientSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("useEncryptedEndpoints".equals(fieldName)) {
                            deserializedServiceNowLinkedService.useEncryptedEndpoints = reader.readUntyped();
                            continue;
                        }
                        if ("useHostVerification".equals(fieldName)) {
                            deserializedServiceNowLinkedService.useHostVerification = reader.readUntyped();
                            continue;
                        }
                        if ("usePeerVerification".equals(fieldName)) {
                            deserializedServiceNowLinkedService.usePeerVerification = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedServiceNowLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedServiceNowLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedServiceNowLinkedService;
        });
    }
}

