/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.RecurrenceFrequency;
import com.azure.analytics.synapse.artifacts.models.RecurrenceSchedule;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ScheduleTriggerRecurrence
implements JsonSerializable<ScheduleTriggerRecurrence> {
    private RecurrenceFrequency frequency;
    private Integer interval;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String timeZone;
    private RecurrenceSchedule schedule;
    private Map<String, Object> additionalProperties;

    public RecurrenceFrequency getFrequency() {
        return this.frequency;
    }

    public ScheduleTriggerRecurrence setFrequency(RecurrenceFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public ScheduleTriggerRecurrence setInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public ScheduleTriggerRecurrence setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public ScheduleTriggerRecurrence setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public ScheduleTriggerRecurrence setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public RecurrenceSchedule getSchedule() {
        return this.schedule;
    }

    public ScheduleTriggerRecurrence setSchedule(RecurrenceSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ScheduleTriggerRecurrence setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("frequency", this.frequency == null ? null : this.frequency.toString());
        jsonWriter.writeNumberField("interval", (Number)this.interval);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("timeZone", this.timeZone);
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ScheduleTriggerRecurrence fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleTriggerRecurrence)jsonReader.readObject(reader -> {
            ScheduleTriggerRecurrence deserializedScheduleTriggerRecurrence = new ScheduleTriggerRecurrence();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frequency".equals(fieldName)) {
                    deserializedScheduleTriggerRecurrence.frequency = RecurrenceFrequency.fromString(reader.getString());
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedScheduleTriggerRecurrence.interval = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedScheduleTriggerRecurrence.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedScheduleTriggerRecurrence.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("timeZone".equals(fieldName)) {
                    deserializedScheduleTriggerRecurrence.timeZone = reader.getString();
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    deserializedScheduleTriggerRecurrence.schedule = RecurrenceSchedule.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedScheduleTriggerRecurrence.additionalProperties = additionalProperties;
            return deserializedScheduleTriggerRecurrence;
        });
    }
}

