/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.MultiplePipelineTrigger;
import com.azure.analytics.synapse.artifacts.models.ScheduleTriggerRecurrence;
import com.azure.analytics.synapse.artifacts.models.TriggerPipelineReference;
import com.azure.analytics.synapse.artifacts.models.TriggerRuntimeState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ScheduleTrigger
extends MultiplePipelineTrigger {
    private String type = "ScheduleTrigger";
    private ScheduleTriggerRecurrence recurrence;

    @Override
    public String getType() {
        return this.type;
    }

    public ScheduleTriggerRecurrence getRecurrence() {
        return this.recurrence;
    }

    public ScheduleTrigger setRecurrence(ScheduleTriggerRecurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    @Override
    public ScheduleTrigger setPipelines(List<TriggerPipelineReference> pipelines) {
        super.setPipelines(pipelines);
        return this;
    }

    @Override
    public ScheduleTrigger setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ScheduleTrigger setAnnotations(List<Object> annotations) {
        super.setAnnotations((List)annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("pipelines", this.getPipelines(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.recurrence != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("recurrence", (JsonSerializable)this.recurrence);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ScheduleTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleTrigger)jsonReader.readObject(reader -> {
            ScheduleTrigger deserializedScheduleTrigger = new ScheduleTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedScheduleTrigger.setDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedScheduleTrigger.setRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedScheduleTrigger.setAnnotations(annotations);
                    continue;
                }
                if ("pipelines".equals(fieldName)) {
                    List pipelines = reader.readArray(reader1 -> TriggerPipelineReference.fromJson(reader1));
                    deserializedScheduleTrigger.setPipelines(pipelines);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedScheduleTrigger.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("recurrence".equals(fieldName)) {
                            deserializedScheduleTrigger.recurrence = ScheduleTriggerRecurrence.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedScheduleTrigger.setAdditionalProperties(additionalProperties);
            return deserializedScheduleTrigger;
        });
    }
}

