/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SalesforceServiceCloudV2ObjectDataset
extends Dataset {
    private String type = "SalesforceServiceCloudV2Object";
    private Object objectApiName;
    private Object reportId;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getObjectApiName() {
        return this.objectApiName;
    }

    public SalesforceServiceCloudV2ObjectDataset setObjectApiName(Object objectApiName) {
        this.objectApiName = objectApiName;
        return this;
    }

    public Object getReportId() {
        return this.reportId;
    }

    public SalesforceServiceCloudV2ObjectDataset setReportId(Object reportId) {
        this.reportId = reportId;
        return this;
    }

    @Override
    public SalesforceServiceCloudV2ObjectDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2ObjectDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2ObjectDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2ObjectDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2ObjectDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2ObjectDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2ObjectDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.objectApiName != null || this.reportId != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.objectApiName != null) {
                jsonWriter.writeUntypedField("objectApiName", this.objectApiName);
            }
            if (this.reportId != null) {
                jsonWriter.writeUntypedField("reportId", this.reportId);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceServiceCloudV2ObjectDataset fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceServiceCloudV2ObjectDataset)jsonReader.readObject(reader -> {
            SalesforceServiceCloudV2ObjectDataset deserializedSalesforceServiceCloudV2ObjectDataset = new SalesforceServiceCloudV2ObjectDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2ObjectDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2ObjectDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2ObjectDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2ObjectDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSalesforceServiceCloudV2ObjectDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSalesforceServiceCloudV2ObjectDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2ObjectDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2ObjectDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("objectApiName".equals(fieldName)) {
                            deserializedSalesforceServiceCloudV2ObjectDataset.objectApiName = reader.readUntyped();
                            continue;
                        }
                        if ("reportId".equals(fieldName)) {
                            deserializedSalesforceServiceCloudV2ObjectDataset.reportId = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceServiceCloudV2ObjectDataset.setAdditionalProperties(additionalProperties);
            return deserializedSalesforceServiceCloudV2ObjectDataset;
        });
    }
}

