/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SalesforceServiceCloudLinkedService
extends LinkedService {
    private String type = "SalesforceServiceCloud";
    private Object environmentUrl;
    private Object username;
    private SecretBase password;
    private SecretBase securityToken;
    private Object apiVersion;
    private Object extendedProperties;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getEnvironmentUrl() {
        return this.environmentUrl;
    }

    public SalesforceServiceCloudLinkedService setEnvironmentUrl(Object environmentUrl) {
        this.environmentUrl = environmentUrl;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public SalesforceServiceCloudLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public SalesforceServiceCloudLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public SecretBase getSecurityToken() {
        return this.securityToken;
    }

    public SalesforceServiceCloudLinkedService setSecurityToken(SecretBase securityToken) {
        this.securityToken = securityToken;
        return this;
    }

    public Object getApiVersion() {
        return this.apiVersion;
    }

    public SalesforceServiceCloudLinkedService setApiVersion(Object apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Object getExtendedProperties() {
        return this.extendedProperties;
    }

    public SalesforceServiceCloudLinkedService setExtendedProperties(Object extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public SalesforceServiceCloudLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public SalesforceServiceCloudLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public SalesforceServiceCloudLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public SalesforceServiceCloudLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SalesforceServiceCloudLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SalesforceServiceCloudLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.environmentUrl != null || this.username != null || this.password != null || this.securityToken != null || this.apiVersion != null || this.extendedProperties != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.environmentUrl != null) {
                jsonWriter.writeUntypedField("environmentUrl", this.environmentUrl);
            }
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            jsonWriter.writeJsonField("securityToken", (JsonSerializable)this.securityToken);
            if (this.apiVersion != null) {
                jsonWriter.writeUntypedField("apiVersion", this.apiVersion);
            }
            if (this.extendedProperties != null) {
                jsonWriter.writeUntypedField("extendedProperties", this.extendedProperties);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceServiceCloudLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceServiceCloudLinkedService)jsonReader.readObject(reader -> {
            SalesforceServiceCloudLinkedService deserializedSalesforceServiceCloudLinkedService = new SalesforceServiceCloudLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSalesforceServiceCloudLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSalesforceServiceCloudLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSalesforceServiceCloudLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSalesforceServiceCloudLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSalesforceServiceCloudLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceServiceCloudLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("environmentUrl".equals(fieldName)) {
                            deserializedSalesforceServiceCloudLinkedService.environmentUrl = reader.readUntyped();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedSalesforceServiceCloudLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedSalesforceServiceCloudLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("securityToken".equals(fieldName)) {
                            deserializedSalesforceServiceCloudLinkedService.securityToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("apiVersion".equals(fieldName)) {
                            deserializedSalesforceServiceCloudLinkedService.apiVersion = reader.readUntyped();
                            continue;
                        }
                        if ("extendedProperties".equals(fieldName)) {
                            deserializedSalesforceServiceCloudLinkedService.extendedProperties = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedSalesforceServiceCloudLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceServiceCloudLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedSalesforceServiceCloudLinkedService;
        });
    }
}

