/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.RestServiceAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RestServiceLinkedService
extends LinkedService {
    private String type = "RestService";
    private Object url;
    private Object enableServerCertificateValidation;
    private RestServiceAuthenticationType authenticationType;
    private Object userName;
    private SecretBase password;
    private Object authHeaders;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object azureCloudType;
    private Object aadResourceId;
    private Object encryptedCredential;
    private CredentialReference credential;
    private Object clientId;
    private SecretBase clientSecret;
    private Object tokenEndpoint;
    private Object resource;
    private Object scope;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalEmbeddedCert;
    private SecretBase servicePrincipalEmbeddedCertPassword;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getUrl() {
        return this.url;
    }

    public RestServiceLinkedService setUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object getEnableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    public RestServiceLinkedService setEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    public RestServiceAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public RestServiceLinkedService setAuthenticationType(RestServiceAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public RestServiceLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public RestServiceLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getAuthHeaders() {
        return this.authHeaders;
    }

    public RestServiceLinkedService setAuthHeaders(Object authHeaders) {
        this.authHeaders = authHeaders;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public RestServiceLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public RestServiceLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public RestServiceLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getAzureCloudType() {
        return this.azureCloudType;
    }

    public RestServiceLinkedService setAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public Object getAadResourceId() {
        return this.aadResourceId;
    }

    public RestServiceLinkedService setAadResourceId(Object aadResourceId) {
        this.aadResourceId = aadResourceId;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public RestServiceLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public RestServiceLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public RestServiceLinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase getClientSecret() {
        return this.clientSecret;
    }

    public RestServiceLinkedService setClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public RestServiceLinkedService setTokenEndpoint(Object tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    public Object getResource() {
        return this.resource;
    }

    public RestServiceLinkedService setResource(Object resource) {
        this.resource = resource;
        return this;
    }

    public Object getScope() {
        return this.scope;
    }

    public RestServiceLinkedService setScope(Object scope) {
        this.scope = scope;
        return this;
    }

    public Object getServicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public RestServiceLinkedService setServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase getServicePrincipalEmbeddedCert() {
        return this.servicePrincipalEmbeddedCert;
    }

    public RestServiceLinkedService setServicePrincipalEmbeddedCert(SecretBase servicePrincipalEmbeddedCert) {
        this.servicePrincipalEmbeddedCert = servicePrincipalEmbeddedCert;
        return this;
    }

    public SecretBase getServicePrincipalEmbeddedCertPassword() {
        return this.servicePrincipalEmbeddedCertPassword;
    }

    public RestServiceLinkedService setServicePrincipalEmbeddedCertPassword(SecretBase servicePrincipalEmbeddedCertPassword) {
        this.servicePrincipalEmbeddedCertPassword = servicePrincipalEmbeddedCertPassword;
        return this;
    }

    @Override
    public RestServiceLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public RestServiceLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public RestServiceLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public RestServiceLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public RestServiceLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.url != null || this.enableServerCertificateValidation != null || this.authenticationType != null || this.userName != null || this.password != null || this.authHeaders != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.tenant != null || this.azureCloudType != null || this.aadResourceId != null || this.encryptedCredential != null || this.credential != null || this.clientId != null || this.clientSecret != null || this.tokenEndpoint != null || this.resource != null || this.scope != null || this.servicePrincipalCredentialType != null || this.servicePrincipalEmbeddedCert != null || this.servicePrincipalEmbeddedCertPassword != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("url", this.url);
            if (this.enableServerCertificateValidation != null) {
                jsonWriter.writeUntypedField("enableServerCertificateValidation", this.enableServerCertificateValidation);
            }
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.userName != null) {
                jsonWriter.writeUntypedField("userName", this.userName);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.authHeaders != null) {
                jsonWriter.writeUntypedField("authHeaders", this.authHeaders);
            }
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            if (this.tenant != null) {
                jsonWriter.writeUntypedField("tenant", this.tenant);
            }
            if (this.azureCloudType != null) {
                jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
            }
            if (this.aadResourceId != null) {
                jsonWriter.writeUntypedField("aadResourceId", this.aadResourceId);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            if (this.clientId != null) {
                jsonWriter.writeUntypedField("clientId", this.clientId);
            }
            jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
            if (this.tokenEndpoint != null) {
                jsonWriter.writeUntypedField("tokenEndpoint", this.tokenEndpoint);
            }
            if (this.resource != null) {
                jsonWriter.writeUntypedField("resource", this.resource);
            }
            if (this.scope != null) {
                jsonWriter.writeUntypedField("scope", this.scope);
            }
            if (this.servicePrincipalCredentialType != null) {
                jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
            }
            jsonWriter.writeJsonField("servicePrincipalEmbeddedCert", (JsonSerializable)this.servicePrincipalEmbeddedCert);
            jsonWriter.writeJsonField("servicePrincipalEmbeddedCertPassword", (JsonSerializable)this.servicePrincipalEmbeddedCertPassword);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RestServiceLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (RestServiceLinkedService)jsonReader.readObject(reader -> {
            RestServiceLinkedService deserializedRestServiceLinkedService = new RestServiceLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedRestServiceLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedRestServiceLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRestServiceLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedRestServiceLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedRestServiceLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestServiceLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("url".equals(fieldName)) {
                            deserializedRestServiceLinkedService.url = reader.readUntyped();
                            continue;
                        }
                        if ("enableServerCertificateValidation".equals(fieldName)) {
                            deserializedRestServiceLinkedService.enableServerCertificateValidation = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedRestServiceLinkedService.authenticationType = RestServiceAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("userName".equals(fieldName)) {
                            deserializedRestServiceLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedRestServiceLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("authHeaders".equals(fieldName)) {
                            deserializedRestServiceLinkedService.authHeaders = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedRestServiceLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedRestServiceLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedRestServiceLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("azureCloudType".equals(fieldName)) {
                            deserializedRestServiceLinkedService.azureCloudType = reader.readUntyped();
                            continue;
                        }
                        if ("aadResourceId".equals(fieldName)) {
                            deserializedRestServiceLinkedService.aadResourceId = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedRestServiceLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedRestServiceLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedRestServiceLinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("clientSecret".equals(fieldName)) {
                            deserializedRestServiceLinkedService.clientSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tokenEndpoint".equals(fieldName)) {
                            deserializedRestServiceLinkedService.tokenEndpoint = reader.readUntyped();
                            continue;
                        }
                        if ("resource".equals(fieldName)) {
                            deserializedRestServiceLinkedService.resource = reader.readUntyped();
                            continue;
                        }
                        if ("scope".equals(fieldName)) {
                            deserializedRestServiceLinkedService.scope = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalCredentialType".equals(fieldName)) {
                            deserializedRestServiceLinkedService.servicePrincipalCredentialType = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalEmbeddedCert".equals(fieldName)) {
                            deserializedRestServiceLinkedService.servicePrincipalEmbeddedCert = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalEmbeddedCertPassword".equals(fieldName)) {
                            deserializedRestServiceLinkedService.servicePrincipalEmbeddedCertPassword = SecretBase.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRestServiceLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedRestServiceLinkedService;
        });
    }
}

