/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ResponsysLinkedService
extends LinkedService {
    private String type = "Responsys";
    private Object endpoint;
    private Object clientId;
    private SecretBase clientSecret;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getEndpoint() {
        return this.endpoint;
    }

    public ResponsysLinkedService setEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public ResponsysLinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase getClientSecret() {
        return this.clientSecret;
    }

    public ResponsysLinkedService setClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object getUseEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public ResponsysLinkedService setUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object getUseHostVerification() {
        return this.useHostVerification;
    }

    public ResponsysLinkedService setUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object getUsePeerVerification() {
        return this.usePeerVerification;
    }

    public ResponsysLinkedService setUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public ResponsysLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public ResponsysLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public ResponsysLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public ResponsysLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ResponsysLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public ResponsysLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.endpoint != null || this.clientId != null || this.clientSecret != null || this.useEncryptedEndpoints != null || this.useHostVerification != null || this.usePeerVerification != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("endpoint", this.endpoint);
            jsonWriter.writeUntypedField("clientId", this.clientId);
            jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
            if (this.useEncryptedEndpoints != null) {
                jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
            }
            if (this.useHostVerification != null) {
                jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
            }
            if (this.usePeerVerification != null) {
                jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ResponsysLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsysLinkedService)jsonReader.readObject(reader -> {
            ResponsysLinkedService deserializedResponsysLinkedService = new ResponsysLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedResponsysLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedResponsysLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedResponsysLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedResponsysLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedResponsysLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResponsysLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("endpoint".equals(fieldName)) {
                            deserializedResponsysLinkedService.endpoint = reader.readUntyped();
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedResponsysLinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("clientSecret".equals(fieldName)) {
                            deserializedResponsysLinkedService.clientSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("useEncryptedEndpoints".equals(fieldName)) {
                            deserializedResponsysLinkedService.useEncryptedEndpoints = reader.readUntyped();
                            continue;
                        }
                        if ("useHostVerification".equals(fieldName)) {
                            deserializedResponsysLinkedService.useHostVerification = reader.readUntyped();
                            continue;
                        }
                        if ("usePeerVerification".equals(fieldName)) {
                            deserializedResponsysLinkedService.usePeerVerification = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedResponsysLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedResponsysLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedResponsysLinkedService;
        });
    }
}

