/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Trigger;
import com.azure.analytics.synapse.artifacts.models.TriggerRuntimeState;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RerunTumblingWindowTrigger
extends Trigger {
    private String type = "RerunTumblingWindowTrigger";
    private Object parentTrigger;
    private OffsetDateTime requestedStartTime;
    private OffsetDateTime requestedEndTime;
    private int rerunConcurrency;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getParentTrigger() {
        return this.parentTrigger;
    }

    public RerunTumblingWindowTrigger setParentTrigger(Object parentTrigger) {
        this.parentTrigger = parentTrigger;
        return this;
    }

    public OffsetDateTime getRequestedStartTime() {
        return this.requestedStartTime;
    }

    public RerunTumblingWindowTrigger setRequestedStartTime(OffsetDateTime requestedStartTime) {
        this.requestedStartTime = requestedStartTime;
        return this;
    }

    public OffsetDateTime getRequestedEndTime() {
        return this.requestedEndTime;
    }

    public RerunTumblingWindowTrigger setRequestedEndTime(OffsetDateTime requestedEndTime) {
        this.requestedEndTime = requestedEndTime;
        return this;
    }

    public int getRerunConcurrency() {
        return this.rerunConcurrency;
    }

    public RerunTumblingWindowTrigger setRerunConcurrency(int rerunConcurrency) {
        this.rerunConcurrency = rerunConcurrency;
        return this;
    }

    @Override
    public RerunTumblingWindowTrigger setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public RerunTumblingWindowTrigger setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStartObject("typeProperties");
        jsonWriter.writeUntypedField("parentTrigger", this.parentTrigger);
        jsonWriter.writeStringField("requestedStartTime", this.requestedStartTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.requestedStartTime));
        jsonWriter.writeStringField("requestedEndTime", this.requestedEndTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.requestedEndTime));
        jsonWriter.writeIntField("rerunConcurrency", this.rerunConcurrency);
        jsonWriter.writeEndObject();
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RerunTumblingWindowTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (RerunTumblingWindowTrigger)jsonReader.readObject(reader -> {
            RerunTumblingWindowTrigger deserializedRerunTumblingWindowTrigger = new RerunTumblingWindowTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedRerunTumblingWindowTrigger.setDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedRerunTumblingWindowTrigger.setRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedRerunTumblingWindowTrigger.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRerunTumblingWindowTrigger.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("parentTrigger".equals(fieldName)) {
                            deserializedRerunTumblingWindowTrigger.parentTrigger = reader.readUntyped();
                            continue;
                        }
                        if ("requestedStartTime".equals(fieldName)) {
                            deserializedRerunTumblingWindowTrigger.requestedStartTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                            continue;
                        }
                        if ("requestedEndTime".equals(fieldName)) {
                            deserializedRerunTumblingWindowTrigger.requestedEndTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                            continue;
                        }
                        if ("rerunConcurrency".equals(fieldName)) {
                            deserializedRerunTumblingWindowTrigger.rerunConcurrency = reader.getInt();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRerunTumblingWindowTrigger.setAdditionalProperties(additionalProperties);
            return deserializedRerunTumblingWindowTrigger;
        });
    }
}

