/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.PrestoAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PrestoLinkedService
extends LinkedService {
    private String type = "Presto";
    private Object host;
    private Object serverVersion;
    private Object catalog;
    private Object port;
    private PrestoAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object enableSsl;
    private Object enableServerCertificateValidation;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private Object allowHostNameCNMismatch;
    private Object allowSelfSignedServerCert;
    private Object timeZoneID;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getHost() {
        return this.host;
    }

    public PrestoLinkedService setHost(Object host) {
        this.host = host;
        return this;
    }

    public Object getServerVersion() {
        return this.serverVersion;
    }

    public PrestoLinkedService setServerVersion(Object serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    public Object getCatalog() {
        return this.catalog;
    }

    public PrestoLinkedService setCatalog(Object catalog) {
        this.catalog = catalog;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public PrestoLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public PrestoAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public PrestoLinkedService setAuthenticationType(PrestoAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public PrestoLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public PrestoLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getEnableSsl() {
        return this.enableSsl;
    }

    public PrestoLinkedService setEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object getEnableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    public PrestoLinkedService setEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    public Object getTrustedCertPath() {
        return this.trustedCertPath;
    }

    public PrestoLinkedService setTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object getUseSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public PrestoLinkedService setUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public Object getAllowHostNameCNMismatch() {
        return this.allowHostNameCNMismatch;
    }

    public PrestoLinkedService setAllowHostNameCNMismatch(Object allowHostNameCNMismatch) {
        this.allowHostNameCNMismatch = allowHostNameCNMismatch;
        return this;
    }

    public Object getAllowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public PrestoLinkedService setAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public Object getTimeZoneID() {
        return this.timeZoneID;
    }

    public PrestoLinkedService setTimeZoneID(Object timeZoneID) {
        this.timeZoneID = timeZoneID;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public PrestoLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public PrestoLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public PrestoLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public PrestoLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public PrestoLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public PrestoLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.host != null || this.serverVersion != null || this.catalog != null || this.port != null || this.authenticationType != null || this.username != null || this.password != null || this.enableSsl != null || this.enableServerCertificateValidation != null || this.trustedCertPath != null || this.useSystemTrustStore != null || this.allowHostNameCNMismatch != null || this.allowSelfSignedServerCert != null || this.timeZoneID != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("host", this.host);
            if (this.serverVersion != null) {
                jsonWriter.writeUntypedField("serverVersion", this.serverVersion);
            }
            jsonWriter.writeUntypedField("catalog", this.catalog);
            if (this.port != null) {
                jsonWriter.writeUntypedField("port", this.port);
            }
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.enableSsl != null) {
                jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
            }
            if (this.enableServerCertificateValidation != null) {
                jsonWriter.writeUntypedField("enableServerCertificateValidation", this.enableServerCertificateValidation);
            }
            if (this.trustedCertPath != null) {
                jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
            }
            if (this.useSystemTrustStore != null) {
                jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
            }
            if (this.allowHostNameCNMismatch != null) {
                jsonWriter.writeUntypedField("allowHostNameCNMismatch", this.allowHostNameCNMismatch);
            }
            if (this.allowSelfSignedServerCert != null) {
                jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
            }
            if (this.timeZoneID != null) {
                jsonWriter.writeUntypedField("timeZoneID", this.timeZoneID);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PrestoLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (PrestoLinkedService)jsonReader.readObject(reader -> {
            PrestoLinkedService deserializedPrestoLinkedService = new PrestoLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedPrestoLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedPrestoLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPrestoLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedPrestoLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedPrestoLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrestoLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("host".equals(fieldName)) {
                            deserializedPrestoLinkedService.host = reader.readUntyped();
                            continue;
                        }
                        if ("serverVersion".equals(fieldName)) {
                            deserializedPrestoLinkedService.serverVersion = reader.readUntyped();
                            continue;
                        }
                        if ("catalog".equals(fieldName)) {
                            deserializedPrestoLinkedService.catalog = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedPrestoLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedPrestoLinkedService.authenticationType = PrestoAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedPrestoLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedPrestoLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("enableSsl".equals(fieldName)) {
                            deserializedPrestoLinkedService.enableSsl = reader.readUntyped();
                            continue;
                        }
                        if ("enableServerCertificateValidation".equals(fieldName)) {
                            deserializedPrestoLinkedService.enableServerCertificateValidation = reader.readUntyped();
                            continue;
                        }
                        if ("trustedCertPath".equals(fieldName)) {
                            deserializedPrestoLinkedService.trustedCertPath = reader.readUntyped();
                            continue;
                        }
                        if ("useSystemTrustStore".equals(fieldName)) {
                            deserializedPrestoLinkedService.useSystemTrustStore = reader.readUntyped();
                            continue;
                        }
                        if ("allowHostNameCNMismatch".equals(fieldName)) {
                            deserializedPrestoLinkedService.allowHostNameCNMismatch = reader.readUntyped();
                            continue;
                        }
                        if ("allowSelfSignedServerCert".equals(fieldName)) {
                            deserializedPrestoLinkedService.allowSelfSignedServerCert = reader.readUntyped();
                            continue;
                        }
                        if ("timeZoneID".equals(fieldName)) {
                            deserializedPrestoLinkedService.timeZoneID = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedPrestoLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPrestoLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedPrestoLinkedService;
        });
    }
}

