/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PowerBIWorkspaceLinkedService
extends LinkedService {
    private String type = "PowerBIWorkspace";
    private String workspaceId;
    private String tenantId;

    @Override
    public String getType() {
        return this.type;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public PowerBIWorkspaceLinkedService setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public PowerBIWorkspaceLinkedService setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public PowerBIWorkspaceLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public PowerBIWorkspaceLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public PowerBIWorkspaceLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public PowerBIWorkspaceLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public PowerBIWorkspaceLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.workspaceId != null || this.tenantId != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeStringField("workspaceId", this.workspaceId);
            jsonWriter.writeStringField("tenantId", this.tenantId);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PowerBIWorkspaceLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (PowerBIWorkspaceLinkedService)jsonReader.readObject(reader -> {
            PowerBIWorkspaceLinkedService deserializedPowerBIWorkspaceLinkedService = new PowerBIWorkspaceLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedPowerBIWorkspaceLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedPowerBIWorkspaceLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPowerBIWorkspaceLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedPowerBIWorkspaceLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedPowerBIWorkspaceLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPowerBIWorkspaceLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("workspaceId".equals(fieldName)) {
                            deserializedPowerBIWorkspaceLinkedService.workspaceId = reader.getString();
                            continue;
                        }
                        if ("tenantId".equals(fieldName)) {
                            deserializedPowerBIWorkspaceLinkedService.tenantId = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPowerBIWorkspaceLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedPowerBIWorkspaceLinkedService;
        });
    }
}

