/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ParameterType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ParameterSpecification
implements JsonSerializable<ParameterSpecification> {
    private ParameterType type;
    private Object defaultValue;

    public ParameterType getType() {
        return this.type;
    }

    public ParameterSpecification setType(ParameterType type) {
        this.type = type;
        return this;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public ParameterSpecification setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (this.defaultValue != null) {
            jsonWriter.writeUntypedField("defaultValue", this.defaultValue);
        }
        return jsonWriter.writeEndObject();
    }

    public static ParameterSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (ParameterSpecification)jsonReader.readObject(reader -> {
            ParameterSpecification deserializedParameterSpecification = new ParameterSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedParameterSpecification.type = ParameterType.fromString(reader.getString());
                    continue;
                }
                if ("defaultValue".equals(fieldName)) {
                    deserializedParameterSpecification.defaultValue = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedParameterSpecification;
        });
    }
}

