/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DatasetStorageFormat;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class OrcFormat
extends DatasetStorageFormat {
    private String type = "OrcFormat";

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public OrcFormat setSerializer(Object serializer) {
        super.setSerializer(serializer);
        return this;
    }

    @Override
    public OrcFormat setDeserializer(Object deserializer) {
        super.setDeserializer(deserializer);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSerializer() != null) {
            jsonWriter.writeUntypedField("serializer", this.getSerializer());
        }
        if (this.getDeserializer() != null) {
            jsonWriter.writeUntypedField("deserializer", this.getDeserializer());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static OrcFormat fromJson(JsonReader jsonReader) throws IOException {
        return (OrcFormat)jsonReader.readObject(reader -> {
            OrcFormat deserializedOrcFormat = new OrcFormat();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serializer".equals(fieldName)) {
                    deserializedOrcFormat.setSerializer(reader.readUntyped());
                    continue;
                }
                if ("deserializer".equals(fieldName)) {
                    deserializedOrcFormat.setDeserializer(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOrcFormat.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedOrcFormat.setAdditionalProperties(additionalProperties);
            return deserializedOrcFormat;
        });
    }
}

