/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.OracleAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OracleLinkedService
extends LinkedService {
    private String type = "Oracle";
    private Object connectionString;
    private Object server;
    private OracleAuthenticationType authenticationType;
    private Object username;
    private AzureKeyVaultSecretReference password;
    private Object encryptionClient;
    private Object encryptionTypesClient;
    private Object cryptoChecksumClient;
    private Object cryptoChecksumTypesClient;
    private Object initialLobFetchSize;
    private Object fetchSize;
    private Object statementCacheSize;
    private Object initializationString;
    private Object enableBulkLoad;
    private Object supportV1DataTypes;
    private Object fetchTswtzAsTimestamp;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public OracleLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object getServer() {
        return this.server;
    }

    public OracleLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public OracleAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public OracleLinkedService setAuthenticationType(OracleAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public OracleLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public AzureKeyVaultSecretReference getPassword() {
        return this.password;
    }

    public OracleLinkedService setPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public Object getEncryptionClient() {
        return this.encryptionClient;
    }

    public OracleLinkedService setEncryptionClient(Object encryptionClient) {
        this.encryptionClient = encryptionClient;
        return this;
    }

    public Object getEncryptionTypesClient() {
        return this.encryptionTypesClient;
    }

    public OracleLinkedService setEncryptionTypesClient(Object encryptionTypesClient) {
        this.encryptionTypesClient = encryptionTypesClient;
        return this;
    }

    public Object getCryptoChecksumClient() {
        return this.cryptoChecksumClient;
    }

    public OracleLinkedService setCryptoChecksumClient(Object cryptoChecksumClient) {
        this.cryptoChecksumClient = cryptoChecksumClient;
        return this;
    }

    public Object getCryptoChecksumTypesClient() {
        return this.cryptoChecksumTypesClient;
    }

    public OracleLinkedService setCryptoChecksumTypesClient(Object cryptoChecksumTypesClient) {
        this.cryptoChecksumTypesClient = cryptoChecksumTypesClient;
        return this;
    }

    public Object getInitialLobFetchSize() {
        return this.initialLobFetchSize;
    }

    public OracleLinkedService setInitialLobFetchSize(Object initialLobFetchSize) {
        this.initialLobFetchSize = initialLobFetchSize;
        return this;
    }

    public Object getFetchSize() {
        return this.fetchSize;
    }

    public OracleLinkedService setFetchSize(Object fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public Object getStatementCacheSize() {
        return this.statementCacheSize;
    }

    public OracleLinkedService setStatementCacheSize(Object statementCacheSize) {
        this.statementCacheSize = statementCacheSize;
        return this;
    }

    public Object getInitializationString() {
        return this.initializationString;
    }

    public OracleLinkedService setInitializationString(Object initializationString) {
        this.initializationString = initializationString;
        return this;
    }

    public Object getEnableBulkLoad() {
        return this.enableBulkLoad;
    }

    public OracleLinkedService setEnableBulkLoad(Object enableBulkLoad) {
        this.enableBulkLoad = enableBulkLoad;
        return this;
    }

    public Object getSupportV1DataTypes() {
        return this.supportV1DataTypes;
    }

    public OracleLinkedService setSupportV1DataTypes(Object supportV1DataTypes) {
        this.supportV1DataTypes = supportV1DataTypes;
        return this;
    }

    public Object getFetchTswtzAsTimestamp() {
        return this.fetchTswtzAsTimestamp;
    }

    public OracleLinkedService setFetchTswtzAsTimestamp(Object fetchTswtzAsTimestamp) {
        this.fetchTswtzAsTimestamp = fetchTswtzAsTimestamp;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public OracleLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public OracleLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public OracleLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public OracleLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public OracleLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public OracleLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionString != null || this.server != null || this.authenticationType != null || this.username != null || this.password != null || this.encryptionClient != null || this.encryptionTypesClient != null || this.cryptoChecksumClient != null || this.cryptoChecksumTypesClient != null || this.initialLobFetchSize != null || this.fetchSize != null || this.statementCacheSize != null || this.initializationString != null || this.enableBulkLoad != null || this.supportV1DataTypes != null || this.fetchTswtzAsTimestamp != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            if (this.server != null) {
                jsonWriter.writeUntypedField("server", this.server);
            }
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.encryptionClient != null) {
                jsonWriter.writeUntypedField("encryptionClient", this.encryptionClient);
            }
            if (this.encryptionTypesClient != null) {
                jsonWriter.writeUntypedField("encryptionTypesClient", this.encryptionTypesClient);
            }
            if (this.cryptoChecksumClient != null) {
                jsonWriter.writeUntypedField("cryptoChecksumClient", this.cryptoChecksumClient);
            }
            if (this.cryptoChecksumTypesClient != null) {
                jsonWriter.writeUntypedField("cryptoChecksumTypesClient", this.cryptoChecksumTypesClient);
            }
            if (this.initialLobFetchSize != null) {
                jsonWriter.writeUntypedField("initialLobFetchSize", this.initialLobFetchSize);
            }
            if (this.fetchSize != null) {
                jsonWriter.writeUntypedField("fetchSize", this.fetchSize);
            }
            if (this.statementCacheSize != null) {
                jsonWriter.writeUntypedField("statementCacheSize", this.statementCacheSize);
            }
            if (this.initializationString != null) {
                jsonWriter.writeUntypedField("initializationString", this.initializationString);
            }
            if (this.enableBulkLoad != null) {
                jsonWriter.writeUntypedField("enableBulkLoad", this.enableBulkLoad);
            }
            if (this.supportV1DataTypes != null) {
                jsonWriter.writeUntypedField("supportV1DataTypes", this.supportV1DataTypes);
            }
            if (this.fetchTswtzAsTimestamp != null) {
                jsonWriter.writeUntypedField("fetchTswtzAsTimestamp", this.fetchTswtzAsTimestamp);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static OracleLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (OracleLinkedService)jsonReader.readObject(reader -> {
            OracleLinkedService deserializedOracleLinkedService = new OracleLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedOracleLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedOracleLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedOracleLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedOracleLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedOracleLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOracleLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionString".equals(fieldName)) {
                            deserializedOracleLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("server".equals(fieldName)) {
                            deserializedOracleLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedOracleLinkedService.authenticationType = OracleAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedOracleLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedOracleLinkedService.password = AzureKeyVaultSecretReference.fromJson(reader);
                            continue;
                        }
                        if ("encryptionClient".equals(fieldName)) {
                            deserializedOracleLinkedService.encryptionClient = reader.readUntyped();
                            continue;
                        }
                        if ("encryptionTypesClient".equals(fieldName)) {
                            deserializedOracleLinkedService.encryptionTypesClient = reader.readUntyped();
                            continue;
                        }
                        if ("cryptoChecksumClient".equals(fieldName)) {
                            deserializedOracleLinkedService.cryptoChecksumClient = reader.readUntyped();
                            continue;
                        }
                        if ("cryptoChecksumTypesClient".equals(fieldName)) {
                            deserializedOracleLinkedService.cryptoChecksumTypesClient = reader.readUntyped();
                            continue;
                        }
                        if ("initialLobFetchSize".equals(fieldName)) {
                            deserializedOracleLinkedService.initialLobFetchSize = reader.readUntyped();
                            continue;
                        }
                        if ("fetchSize".equals(fieldName)) {
                            deserializedOracleLinkedService.fetchSize = reader.readUntyped();
                            continue;
                        }
                        if ("statementCacheSize".equals(fieldName)) {
                            deserializedOracleLinkedService.statementCacheSize = reader.readUntyped();
                            continue;
                        }
                        if ("initializationString".equals(fieldName)) {
                            deserializedOracleLinkedService.initializationString = reader.readUntyped();
                            continue;
                        }
                        if ("enableBulkLoad".equals(fieldName)) {
                            deserializedOracleLinkedService.enableBulkLoad = reader.readUntyped();
                            continue;
                        }
                        if ("supportV1DataTypes".equals(fieldName)) {
                            deserializedOracleLinkedService.supportV1DataTypes = reader.readUntyped();
                            continue;
                        }
                        if ("fetchTswtzAsTimestamp".equals(fieldName)) {
                            deserializedOracleLinkedService.fetchTswtzAsTimestamp = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedOracleLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedOracleLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedOracleLinkedService;
        });
    }
}

