/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CloudError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class OperationResult
implements JsonSerializable<OperationResult> {
    private String status;
    private String code;
    private String message;
    private String target;
    private List<CloudError> details;

    public String getStatus() {
        return this.status;
    }

    public String getCode() {
        return this.code;
    }

    public OperationResult setCode(String code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public OperationResult setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public OperationResult setTarget(String target) {
        this.target = target;
        return this;
    }

    public List<CloudError> getDetails() {
        return this.details;
    }

    public OperationResult setDetails(List<CloudError> details) {
        this.details = details;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.code != null || this.message != null || this.target != null || this.details != null) {
            jsonWriter.writeStartObject("error");
            jsonWriter.writeStringField("code", this.code);
            jsonWriter.writeStringField("message", this.message);
            jsonWriter.writeStringField("target", this.target);
            jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static OperationResult fromJson(JsonReader jsonReader) throws IOException {
        return (OperationResult)jsonReader.readObject(reader -> {
            OperationResult deserializedOperationResult = new OperationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedOperationResult.status = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("code".equals(fieldName)) {
                            deserializedOperationResult.code = reader.getString();
                            continue;
                        }
                        if ("message".equals(fieldName)) {
                            deserializedOperationResult.message = reader.getString();
                            continue;
                        }
                        if ("target".equals(fieldName)) {
                            deserializedOperationResult.target = reader.getString();
                            continue;
                        }
                        if ("details".equals(fieldName)) {
                            List details;
                            deserializedOperationResult.details = details = reader.readArray(reader1 -> CloudError.fromJson(reader1));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationResult;
        });
    }
}

