/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ODataAadServicePrincipalCredentialType;
import com.azure.analytics.synapse.artifacts.models.ODataAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ODataLinkedService
extends LinkedService {
    private String type = "OData";
    private Object url;
    private ODataAuthenticationType authenticationType;
    private Object userName;
    private SecretBase password;
    private Object tenant;
    private Object servicePrincipalId;
    private Object azureCloudType;
    private Object aadResourceId;
    private ODataAadServicePrincipalCredentialType aadServicePrincipalCredentialType;
    private SecretBase servicePrincipalKey;
    private SecretBase servicePrincipalEmbeddedCert;
    private SecretBase servicePrincipalEmbeddedCertPassword;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getUrl() {
        return this.url;
    }

    public ODataLinkedService setUrl(Object url) {
        this.url = url;
        return this;
    }

    public ODataAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public ODataLinkedService setAuthenticationType(ODataAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public ODataLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public ODataLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public ODataLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public ODataLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public Object getAzureCloudType() {
        return this.azureCloudType;
    }

    public ODataLinkedService setAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public Object getAadResourceId() {
        return this.aadResourceId;
    }

    public ODataLinkedService setAadResourceId(Object aadResourceId) {
        this.aadResourceId = aadResourceId;
        return this;
    }

    public ODataAadServicePrincipalCredentialType getAadServicePrincipalCredentialType() {
        return this.aadServicePrincipalCredentialType;
    }

    public ODataLinkedService setAadServicePrincipalCredentialType(ODataAadServicePrincipalCredentialType aadServicePrincipalCredentialType) {
        this.aadServicePrincipalCredentialType = aadServicePrincipalCredentialType;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public ODataLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public SecretBase getServicePrincipalEmbeddedCert() {
        return this.servicePrincipalEmbeddedCert;
    }

    public ODataLinkedService setServicePrincipalEmbeddedCert(SecretBase servicePrincipalEmbeddedCert) {
        this.servicePrincipalEmbeddedCert = servicePrincipalEmbeddedCert;
        return this;
    }

    public SecretBase getServicePrincipalEmbeddedCertPassword() {
        return this.servicePrincipalEmbeddedCertPassword;
    }

    public ODataLinkedService setServicePrincipalEmbeddedCertPassword(SecretBase servicePrincipalEmbeddedCertPassword) {
        this.servicePrincipalEmbeddedCertPassword = servicePrincipalEmbeddedCertPassword;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public ODataLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public ODataLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public ODataLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public ODataLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ODataLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public ODataLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.url != null || this.authenticationType != null || this.userName != null || this.password != null || this.tenant != null || this.servicePrincipalId != null || this.azureCloudType != null || this.aadResourceId != null || this.aadServicePrincipalCredentialType != null || this.servicePrincipalKey != null || this.servicePrincipalEmbeddedCert != null || this.servicePrincipalEmbeddedCertPassword != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("url", this.url);
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.userName != null) {
                jsonWriter.writeUntypedField("userName", this.userName);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.tenant != null) {
                jsonWriter.writeUntypedField("tenant", this.tenant);
            }
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            if (this.azureCloudType != null) {
                jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
            }
            if (this.aadResourceId != null) {
                jsonWriter.writeUntypedField("aadResourceId", this.aadResourceId);
            }
            jsonWriter.writeStringField("aadServicePrincipalCredentialType", this.aadServicePrincipalCredentialType == null ? null : this.aadServicePrincipalCredentialType.toString());
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            jsonWriter.writeJsonField("servicePrincipalEmbeddedCert", (JsonSerializable)this.servicePrincipalEmbeddedCert);
            jsonWriter.writeJsonField("servicePrincipalEmbeddedCertPassword", (JsonSerializable)this.servicePrincipalEmbeddedCertPassword);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ODataLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (ODataLinkedService)jsonReader.readObject(reader -> {
            ODataLinkedService deserializedODataLinkedService = new ODataLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedODataLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedODataLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedODataLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedODataLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedODataLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedODataLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("url".equals(fieldName)) {
                            deserializedODataLinkedService.url = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedODataLinkedService.authenticationType = ODataAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("userName".equals(fieldName)) {
                            deserializedODataLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedODataLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedODataLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedODataLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("azureCloudType".equals(fieldName)) {
                            deserializedODataLinkedService.azureCloudType = reader.readUntyped();
                            continue;
                        }
                        if ("aadResourceId".equals(fieldName)) {
                            deserializedODataLinkedService.aadResourceId = reader.readUntyped();
                            continue;
                        }
                        if ("aadServicePrincipalCredentialType".equals(fieldName)) {
                            deserializedODataLinkedService.aadServicePrincipalCredentialType = ODataAadServicePrincipalCredentialType.fromString(reader.getString());
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedODataLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalEmbeddedCert".equals(fieldName)) {
                            deserializedODataLinkedService.servicePrincipalEmbeddedCert = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalEmbeddedCertPassword".equals(fieldName)) {
                            deserializedODataLinkedService.servicePrincipalEmbeddedCertPassword = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedODataLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedODataLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedODataLinkedService;
        });
    }
}

