/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.BigDataPoolReference;
import com.azure.analytics.synapse.artifacts.models.NotebookCell;
import com.azure.analytics.synapse.artifacts.models.NotebookFolder;
import com.azure.analytics.synapse.artifacts.models.NotebookMetadata;
import com.azure.analytics.synapse.artifacts.models.NotebookSessionProperties;
import com.azure.analytics.synapse.artifacts.models.SparkConfigurationReference;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Notebook
implements JsonSerializable<Notebook> {
    private String description;
    private BigDataPoolReference bigDataPool;
    private SparkConfigurationReference targetSparkConfiguration;
    private NotebookSessionProperties sessionProperties;
    private NotebookMetadata metadata;
    private int nbformat;
    private int nbformatMinor;
    private List<NotebookCell> cells;
    private NotebookFolder folder;
    private Map<String, Object> additionalProperties;

    public String getDescription() {
        return this.description;
    }

    public Notebook setDescription(String description) {
        this.description = description;
        return this;
    }

    public BigDataPoolReference getBigDataPool() {
        return this.bigDataPool;
    }

    public Notebook setBigDataPool(BigDataPoolReference bigDataPool) {
        this.bigDataPool = bigDataPool;
        return this;
    }

    public SparkConfigurationReference getTargetSparkConfiguration() {
        return this.targetSparkConfiguration;
    }

    public Notebook setTargetSparkConfiguration(SparkConfigurationReference targetSparkConfiguration) {
        this.targetSparkConfiguration = targetSparkConfiguration;
        return this;
    }

    public NotebookSessionProperties getSessionProperties() {
        return this.sessionProperties;
    }

    public Notebook setSessionProperties(NotebookSessionProperties sessionProperties) {
        this.sessionProperties = sessionProperties;
        return this;
    }

    public NotebookMetadata getMetadata() {
        return this.metadata;
    }

    public Notebook setMetadata(NotebookMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public int getNbformat() {
        return this.nbformat;
    }

    public Notebook setNbformat(int nbformat) {
        this.nbformat = nbformat;
        return this;
    }

    public int getNbformatMinor() {
        return this.nbformatMinor;
    }

    public Notebook setNbformatMinor(int nbformatMinor) {
        this.nbformatMinor = nbformatMinor;
        return this;
    }

    public List<NotebookCell> getCells() {
        return this.cells;
    }

    public Notebook setCells(List<NotebookCell> cells) {
        this.cells = cells;
        return this;
    }

    public NotebookFolder getFolder() {
        return this.folder;
    }

    public Notebook setFolder(NotebookFolder folder) {
        this.folder = folder;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Notebook setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("metadata", (JsonSerializable)this.metadata);
        jsonWriter.writeIntField("nbformat", this.nbformat);
        jsonWriter.writeIntField("nbformat_minor", this.nbformatMinor);
        jsonWriter.writeArrayField("cells", this.cells, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("bigDataPool", (JsonSerializable)this.bigDataPool);
        jsonWriter.writeJsonField("targetSparkConfiguration", (JsonSerializable)this.targetSparkConfiguration);
        jsonWriter.writeJsonField("sessionProperties", (JsonSerializable)this.sessionProperties);
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static Notebook fromJson(JsonReader jsonReader) throws IOException {
        return (Notebook)jsonReader.readObject(reader -> {
            Notebook deserializedNotebook = new Notebook();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metadata".equals(fieldName)) {
                    deserializedNotebook.metadata = NotebookMetadata.fromJson(reader);
                    continue;
                }
                if ("nbformat".equals(fieldName)) {
                    deserializedNotebook.nbformat = reader.getInt();
                    continue;
                }
                if ("nbformat_minor".equals(fieldName)) {
                    deserializedNotebook.nbformatMinor = reader.getInt();
                    continue;
                }
                if ("cells".equals(fieldName)) {
                    List cells;
                    deserializedNotebook.cells = cells = reader.readArray(reader1 -> NotebookCell.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedNotebook.description = reader.getString();
                    continue;
                }
                if ("bigDataPool".equals(fieldName)) {
                    deserializedNotebook.bigDataPool = BigDataPoolReference.fromJson(reader);
                    continue;
                }
                if ("targetSparkConfiguration".equals(fieldName)) {
                    deserializedNotebook.targetSparkConfiguration = SparkConfigurationReference.fromJson(reader);
                    continue;
                }
                if ("sessionProperties".equals(fieldName)) {
                    deserializedNotebook.sessionProperties = NotebookSessionProperties.fromJson(reader);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedNotebook.folder = NotebookFolder.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedNotebook.additionalProperties = additionalProperties;
            return deserializedNotebook;
        });
    }
}

