/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NetezzaTableDataset
extends Dataset {
    private String type = "NetezzaTable";
    private Object tableName;
    private Object table;
    private Object schemaTypePropertiesSchema;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getTableName() {
        return this.tableName;
    }

    public NetezzaTableDataset setTableName(Object tableName) {
        this.tableName = tableName;
        return this;
    }

    public Object getTable() {
        return this.table;
    }

    public NetezzaTableDataset setTable(Object table) {
        this.table = table;
        return this;
    }

    public Object getSchemaTypePropertiesSchema() {
        return this.schemaTypePropertiesSchema;
    }

    public NetezzaTableDataset setSchemaTypePropertiesSchema(Object schemaTypePropertiesSchema) {
        this.schemaTypePropertiesSchema = schemaTypePropertiesSchema;
        return this;
    }

    @Override
    public NetezzaTableDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public NetezzaTableDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public NetezzaTableDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public NetezzaTableDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public NetezzaTableDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public NetezzaTableDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public NetezzaTableDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.tableName != null || this.table != null || this.schemaTypePropertiesSchema != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.tableName != null) {
                jsonWriter.writeUntypedField("tableName", this.tableName);
            }
            if (this.table != null) {
                jsonWriter.writeUntypedField("table", this.table);
            }
            if (this.schemaTypePropertiesSchema != null) {
                jsonWriter.writeUntypedField("schema", this.schemaTypePropertiesSchema);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static NetezzaTableDataset fromJson(JsonReader jsonReader) throws IOException {
        return (NetezzaTableDataset)jsonReader.readObject(reader -> {
            NetezzaTableDataset deserializedNetezzaTableDataset = new NetezzaTableDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedNetezzaTableDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedNetezzaTableDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedNetezzaTableDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedNetezzaTableDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedNetezzaTableDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedNetezzaTableDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedNetezzaTableDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetezzaTableDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("tableName".equals(fieldName)) {
                            deserializedNetezzaTableDataset.tableName = reader.readUntyped();
                            continue;
                        }
                        if ("table".equals(fieldName)) {
                            deserializedNetezzaTableDataset.table = reader.readUntyped();
                            continue;
                        }
                        if ("schema".equals(fieldName)) {
                            deserializedNetezzaTableDataset.schemaTypePropertiesSchema = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedNetezzaTableDataset.setAdditionalProperties(additionalProperties);
            return deserializedNetezzaTableDataset;
        });
    }
}

