/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.MongoDbAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MongoDbLinkedService
extends LinkedService {
    private String type = "MongoDb";
    private Object server;
    private MongoDbAuthenticationType authenticationType;
    private Object databaseName;
    private Object username;
    private SecretBase password;
    private Object authSource;
    private Object port;
    private Object enableSsl;
    private Object allowSelfSignedServerCert;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getServer() {
        return this.server;
    }

    public MongoDbLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public MongoDbAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public MongoDbLinkedService setAuthenticationType(MongoDbAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getDatabaseName() {
        return this.databaseName;
    }

    public MongoDbLinkedService setDatabaseName(Object databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public MongoDbLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public MongoDbLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getAuthSource() {
        return this.authSource;
    }

    public MongoDbLinkedService setAuthSource(Object authSource) {
        this.authSource = authSource;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public MongoDbLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public Object getEnableSsl() {
        return this.enableSsl;
    }

    public MongoDbLinkedService setEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object getAllowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public MongoDbLinkedService setAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public MongoDbLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public MongoDbLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public MongoDbLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public MongoDbLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public MongoDbLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public MongoDbLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.server != null || this.authenticationType != null || this.databaseName != null || this.username != null || this.password != null || this.authSource != null || this.port != null || this.enableSsl != null || this.allowSelfSignedServerCert != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("server", this.server);
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            jsonWriter.writeUntypedField("databaseName", this.databaseName);
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.authSource != null) {
                jsonWriter.writeUntypedField("authSource", this.authSource);
            }
            if (this.port != null) {
                jsonWriter.writeUntypedField("port", this.port);
            }
            if (this.enableSsl != null) {
                jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
            }
            if (this.allowSelfSignedServerCert != null) {
                jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MongoDbLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbLinkedService)jsonReader.readObject(reader -> {
            MongoDbLinkedService deserializedMongoDbLinkedService = new MongoDbLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedMongoDbLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedMongoDbLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMongoDbLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedMongoDbLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedMongoDbLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDbLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("server".equals(fieldName)) {
                            deserializedMongoDbLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedMongoDbLinkedService.authenticationType = MongoDbAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("databaseName".equals(fieldName)) {
                            deserializedMongoDbLinkedService.databaseName = reader.readUntyped();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedMongoDbLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedMongoDbLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("authSource".equals(fieldName)) {
                            deserializedMongoDbLinkedService.authSource = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedMongoDbLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("enableSsl".equals(fieldName)) {
                            deserializedMongoDbLinkedService.enableSsl = reader.readUntyped();
                            continue;
                        }
                        if ("allowSelfSignedServerCert".equals(fieldName)) {
                            deserializedMongoDbLinkedService.allowSelfSignedServerCert = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedMongoDbLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMongoDbLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedMongoDbLinkedService;
        });
    }
}

