/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntime;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeComputeProperties;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeSsisProperties;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeState;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeType;
import com.azure.analytics.synapse.artifacts.models.ManagedVirtualNetworkReference;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ManagedIntegrationRuntime
extends IntegrationRuntime {
    private IntegrationRuntimeType type = IntegrationRuntimeType.MANAGED;
    private IntegrationRuntimeState state;
    private ManagedVirtualNetworkReference managedVirtualNetwork;
    private IntegrationRuntimeComputeProperties computeProperties;
    private IntegrationRuntimeSsisProperties ssisProperties;

    @Override
    public IntegrationRuntimeType getType() {
        return this.type;
    }

    public IntegrationRuntimeState getState() {
        return this.state;
    }

    public ManagedVirtualNetworkReference getManagedVirtualNetwork() {
        return this.managedVirtualNetwork;
    }

    public ManagedIntegrationRuntime setManagedVirtualNetwork(ManagedVirtualNetworkReference managedVirtualNetwork) {
        this.managedVirtualNetwork = managedVirtualNetwork;
        return this;
    }

    public IntegrationRuntimeComputeProperties getComputeProperties() {
        return this.computeProperties;
    }

    public ManagedIntegrationRuntime setComputeProperties(IntegrationRuntimeComputeProperties computeProperties) {
        this.computeProperties = computeProperties;
        return this;
    }

    public IntegrationRuntimeSsisProperties getSsisProperties() {
        return this.ssisProperties;
    }

    public ManagedIntegrationRuntime setSsisProperties(IntegrationRuntimeSsisProperties ssisProperties) {
        this.ssisProperties = ssisProperties;
        return this;
    }

    @Override
    public ManagedIntegrationRuntime setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("managedVirtualNetwork", (JsonSerializable)this.managedVirtualNetwork);
        if (this.computeProperties != null || this.ssisProperties != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("computeProperties", (JsonSerializable)this.computeProperties);
            jsonWriter.writeJsonField("ssisProperties", (JsonSerializable)this.ssisProperties);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ManagedIntegrationRuntime fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedIntegrationRuntime)jsonReader.readObject(reader -> {
            ManagedIntegrationRuntime deserializedManagedIntegrationRuntime = new ManagedIntegrationRuntime();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedManagedIntegrationRuntime.setDescription(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedIntegrationRuntime.type = IntegrationRuntimeType.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedManagedIntegrationRuntime.state = IntegrationRuntimeState.fromString(reader.getString());
                    continue;
                }
                if ("managedVirtualNetwork".equals(fieldName)) {
                    deserializedManagedIntegrationRuntime.managedVirtualNetwork = ManagedVirtualNetworkReference.fromJson(reader);
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("computeProperties".equals(fieldName)) {
                            deserializedManagedIntegrationRuntime.computeProperties = IntegrationRuntimeComputeProperties.fromJson(reader);
                            continue;
                        }
                        if ("ssisProperties".equals(fieldName)) {
                            deserializedManagedIntegrationRuntime.ssisProperties = IntegrationRuntimeSsisProperties.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedManagedIntegrationRuntime.setAdditionalProperties(additionalProperties);
            return deserializedManagedIntegrationRuntime;
        });
    }
}

