/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeDataFlowProperties;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeVNetProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class IntegrationRuntimeComputeProperties
implements JsonSerializable<IntegrationRuntimeComputeProperties> {
    private String location;
    private String nodeSize;
    private Integer numberOfNodes;
    private Integer maxParallelExecutionsPerNode;
    private IntegrationRuntimeDataFlowProperties dataFlowProperties;
    private IntegrationRuntimeVNetProperties vNetProperties;
    private Map<String, Object> additionalProperties;

    public String getLocation() {
        return this.location;
    }

    public IntegrationRuntimeComputeProperties setLocation(String location) {
        this.location = location;
        return this;
    }

    public String getNodeSize() {
        return this.nodeSize;
    }

    public IntegrationRuntimeComputeProperties setNodeSize(String nodeSize) {
        this.nodeSize = nodeSize;
        return this;
    }

    public Integer getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public IntegrationRuntimeComputeProperties setNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
        return this;
    }

    public Integer getMaxParallelExecutionsPerNode() {
        return this.maxParallelExecutionsPerNode;
    }

    public IntegrationRuntimeComputeProperties setMaxParallelExecutionsPerNode(Integer maxParallelExecutionsPerNode) {
        this.maxParallelExecutionsPerNode = maxParallelExecutionsPerNode;
        return this;
    }

    public IntegrationRuntimeDataFlowProperties getDataFlowProperties() {
        return this.dataFlowProperties;
    }

    public IntegrationRuntimeComputeProperties setDataFlowProperties(IntegrationRuntimeDataFlowProperties dataFlowProperties) {
        this.dataFlowProperties = dataFlowProperties;
        return this;
    }

    public IntegrationRuntimeVNetProperties getVNetProperties() {
        return this.vNetProperties;
    }

    public IntegrationRuntimeComputeProperties setVNetProperties(IntegrationRuntimeVNetProperties vNetProperties) {
        this.vNetProperties = vNetProperties;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public IntegrationRuntimeComputeProperties setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeStringField("nodeSize", this.nodeSize);
        jsonWriter.writeNumberField("numberOfNodes", (Number)this.numberOfNodes);
        jsonWriter.writeNumberField("maxParallelExecutionsPerNode", (Number)this.maxParallelExecutionsPerNode);
        jsonWriter.writeJsonField("dataFlowProperties", (JsonSerializable)this.dataFlowProperties);
        jsonWriter.writeJsonField("vNetProperties", (JsonSerializable)this.vNetProperties);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeComputeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeComputeProperties)jsonReader.readObject(reader -> {
            IntegrationRuntimeComputeProperties deserializedIntegrationRuntimeComputeProperties = new IntegrationRuntimeComputeProperties();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.location = reader.getString();
                    continue;
                }
                if ("nodeSize".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.nodeSize = reader.getString();
                    continue;
                }
                if ("numberOfNodes".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.numberOfNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxParallelExecutionsPerNode".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.maxParallelExecutionsPerNode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dataFlowProperties".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.dataFlowProperties = IntegrationRuntimeDataFlowProperties.fromJson(reader);
                    continue;
                }
                if ("vNetProperties".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.vNetProperties = IntegrationRuntimeVNetProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIntegrationRuntimeComputeProperties.additionalProperties = additionalProperties;
            return deserializedIntegrationRuntimeComputeProperties;
        });
    }
}

