/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightActivityDebugInfoOption;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HDInsightSparkActivity
extends ExecutionActivity {
    private String type = "HDInsightSpark";
    private Object rootPath;
    private Object entryFilePath;
    private List<Object> arguments;
    private HDInsightActivityDebugInfoOption getDebugInfo;
    private LinkedServiceReference sparkJobLinkedService;
    private String className;
    private Object proxyUser;
    private Map<String, Object> sparkConfig;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getRootPath() {
        return this.rootPath;
    }

    public HDInsightSparkActivity setRootPath(Object rootPath) {
        this.rootPath = rootPath;
        return this;
    }

    public Object getEntryFilePath() {
        return this.entryFilePath;
    }

    public HDInsightSparkActivity setEntryFilePath(Object entryFilePath) {
        this.entryFilePath = entryFilePath;
        return this;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public HDInsightSparkActivity setArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public HDInsightActivityDebugInfoOption getGetDebugInfo() {
        return this.getDebugInfo;
    }

    public HDInsightSparkActivity setGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    public LinkedServiceReference getSparkJobLinkedService() {
        return this.sparkJobLinkedService;
    }

    public HDInsightSparkActivity setSparkJobLinkedService(LinkedServiceReference sparkJobLinkedService) {
        this.sparkJobLinkedService = sparkJobLinkedService;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public HDInsightSparkActivity setClassName(String className) {
        this.className = className;
        return this;
    }

    public Object getProxyUser() {
        return this.proxyUser;
    }

    public HDInsightSparkActivity setProxyUser(Object proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public Map<String, Object> getSparkConfig() {
        return this.sparkConfig;
    }

    public HDInsightSparkActivity setSparkConfig(Map<String, Object> sparkConfig) {
        this.sparkConfig = sparkConfig;
        return this;
    }

    @Override
    public HDInsightSparkActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public HDInsightSparkActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public HDInsightSparkActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public HDInsightSparkActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public HDInsightSparkActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public HDInsightSparkActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public HDInsightSparkActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public HDInsightSparkActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.rootPath != null || this.entryFilePath != null || this.arguments != null || this.getDebugInfo != null || this.sparkJobLinkedService != null || this.className != null || this.proxyUser != null || this.sparkConfig != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("rootPath", this.rootPath);
            jsonWriter.writeUntypedField("entryFilePath", this.entryFilePath);
            jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeStringField("getDebugInfo", this.getDebugInfo == null ? null : this.getDebugInfo.toString());
            jsonWriter.writeJsonField("sparkJobLinkedService", (JsonSerializable)this.sparkJobLinkedService);
            jsonWriter.writeStringField("className", this.className);
            if (this.proxyUser != null) {
                jsonWriter.writeUntypedField("proxyUser", this.proxyUser);
            }
            jsonWriter.writeMapField("sparkConfig", this.sparkConfig, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HDInsightSparkActivity fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightSparkActivity)jsonReader.readObject(reader -> {
            HDInsightSparkActivity deserializedHDInsightSparkActivity = new HDInsightSparkActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedHDInsightSparkActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedHDInsightSparkActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("rootPath".equals(fieldName)) {
                            deserializedHDInsightSparkActivity.rootPath = reader.readUntyped();
                            continue;
                        }
                        if ("entryFilePath".equals(fieldName)) {
                            deserializedHDInsightSparkActivity.entryFilePath = reader.readUntyped();
                            continue;
                        }
                        if ("arguments".equals(fieldName)) {
                            List arguments;
                            deserializedHDInsightSparkActivity.arguments = arguments = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("getDebugInfo".equals(fieldName)) {
                            deserializedHDInsightSparkActivity.getDebugInfo = HDInsightActivityDebugInfoOption.fromString(reader.getString());
                            continue;
                        }
                        if ("sparkJobLinkedService".equals(fieldName)) {
                            deserializedHDInsightSparkActivity.sparkJobLinkedService = LinkedServiceReference.fromJson(reader);
                            continue;
                        }
                        if ("className".equals(fieldName)) {
                            deserializedHDInsightSparkActivity.className = reader.getString();
                            continue;
                        }
                        if ("proxyUser".equals(fieldName)) {
                            deserializedHDInsightSparkActivity.proxyUser = reader.readUntyped();
                            continue;
                        }
                        if ("sparkConfig".equals(fieldName)) {
                            Map sparkConfig;
                            deserializedHDInsightSparkActivity.sparkConfig = sparkConfig = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHDInsightSparkActivity.setAdditionalProperties(additionalProperties);
            return deserializedHDInsightSparkActivity;
        });
    }
}

