/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.GreenplumAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GreenplumLinkedService
extends LinkedService {
    private String type = "Greenplum";
    private Object connectionString;
    private AzureKeyVaultSecretReference pwd;
    private Object encryptedCredential;
    private GreenplumAuthenticationType authenticationType;
    private Object host;
    private Object port;
    private Object username;
    private Object database;
    private Object sslMode;
    private Object connectionTimeout;
    private Object commandTimeout;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public GreenplumLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureKeyVaultSecretReference getPwd() {
        return this.pwd;
    }

    public GreenplumLinkedService setPwd(AzureKeyVaultSecretReference pwd) {
        this.pwd = pwd;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public GreenplumLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public GreenplumAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public GreenplumLinkedService setAuthenticationType(GreenplumAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getHost() {
        return this.host;
    }

    public GreenplumLinkedService setHost(Object host) {
        this.host = host;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public GreenplumLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public GreenplumLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public GreenplumLinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object getSslMode() {
        return this.sslMode;
    }

    public GreenplumLinkedService setSslMode(Object sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public Object getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public GreenplumLinkedService setConnectionTimeout(Object connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Object getCommandTimeout() {
        return this.commandTimeout;
    }

    public GreenplumLinkedService setCommandTimeout(Object commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    @Override
    public GreenplumLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public GreenplumLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public GreenplumLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public GreenplumLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public GreenplumLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionString != null || this.pwd != null || this.encryptedCredential != null || this.authenticationType != null || this.host != null || this.port != null || this.username != null || this.database != null || this.sslMode != null || this.connectionTimeout != null || this.commandTimeout != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            jsonWriter.writeJsonField("pwd", (JsonSerializable)this.pwd);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.host != null) {
                jsonWriter.writeUntypedField("host", this.host);
            }
            if (this.port != null) {
                jsonWriter.writeUntypedField("port", this.port);
            }
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            if (this.database != null) {
                jsonWriter.writeUntypedField("database", this.database);
            }
            if (this.sslMode != null) {
                jsonWriter.writeUntypedField("sslMode", this.sslMode);
            }
            if (this.connectionTimeout != null) {
                jsonWriter.writeUntypedField("connectionTimeout", this.connectionTimeout);
            }
            if (this.commandTimeout != null) {
                jsonWriter.writeUntypedField("commandTimeout", this.commandTimeout);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GreenplumLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (GreenplumLinkedService)jsonReader.readObject(reader -> {
            GreenplumLinkedService deserializedGreenplumLinkedService = new GreenplumLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedGreenplumLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedGreenplumLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGreenplumLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedGreenplumLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedGreenplumLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGreenplumLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionString".equals(fieldName)) {
                            deserializedGreenplumLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("pwd".equals(fieldName)) {
                            deserializedGreenplumLinkedService.pwd = AzureKeyVaultSecretReference.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedGreenplumLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedGreenplumLinkedService.authenticationType = GreenplumAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("host".equals(fieldName)) {
                            deserializedGreenplumLinkedService.host = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedGreenplumLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedGreenplumLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedGreenplumLinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("sslMode".equals(fieldName)) {
                            deserializedGreenplumLinkedService.sslMode = reader.readUntyped();
                            continue;
                        }
                        if ("connectionTimeout".equals(fieldName)) {
                            deserializedGreenplumLinkedService.connectionTimeout = reader.readUntyped();
                            continue;
                        }
                        if ("commandTimeout".equals(fieldName)) {
                            deserializedGreenplumLinkedService.commandTimeout = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGreenplumLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedGreenplumLinkedService;
        });
    }
}

