/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.GoogleAdWordsAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GoogleAdWordsLinkedService
extends LinkedService {
    private String type = "GoogleAdWords";
    private Object connectionProperties;
    private Object clientCustomerID;
    private SecretBase developerToken;
    private GoogleAdWordsAuthenticationType authenticationType;
    private SecretBase refreshToken;
    private Object clientId;
    private SecretBase clientSecret;
    private Object email;
    private Object keyFilePath;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private SecretBase privateKey;
    private Object loginCustomerID;
    private Object googleAdsApiVersion;
    private Object supportLegacyDataTypes;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionProperties() {
        return this.connectionProperties;
    }

    public GoogleAdWordsLinkedService setConnectionProperties(Object connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public Object getClientCustomerID() {
        return this.clientCustomerID;
    }

    public GoogleAdWordsLinkedService setClientCustomerID(Object clientCustomerID) {
        this.clientCustomerID = clientCustomerID;
        return this;
    }

    public SecretBase getDeveloperToken() {
        return this.developerToken;
    }

    public GoogleAdWordsLinkedService setDeveloperToken(SecretBase developerToken) {
        this.developerToken = developerToken;
        return this;
    }

    public GoogleAdWordsAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public GoogleAdWordsLinkedService setAuthenticationType(GoogleAdWordsAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public SecretBase getRefreshToken() {
        return this.refreshToken;
    }

    public GoogleAdWordsLinkedService setRefreshToken(SecretBase refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public GoogleAdWordsLinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase getClientSecret() {
        return this.clientSecret;
    }

    public GoogleAdWordsLinkedService setClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object getEmail() {
        return this.email;
    }

    public GoogleAdWordsLinkedService setEmail(Object email) {
        this.email = email;
        return this;
    }

    public Object getKeyFilePath() {
        return this.keyFilePath;
    }

    public GoogleAdWordsLinkedService setKeyFilePath(Object keyFilePath) {
        this.keyFilePath = keyFilePath;
        return this;
    }

    public Object getTrustedCertPath() {
        return this.trustedCertPath;
    }

    public GoogleAdWordsLinkedService setTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object getUseSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public GoogleAdWordsLinkedService setUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public SecretBase getPrivateKey() {
        return this.privateKey;
    }

    public GoogleAdWordsLinkedService setPrivateKey(SecretBase privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public Object getLoginCustomerID() {
        return this.loginCustomerID;
    }

    public GoogleAdWordsLinkedService setLoginCustomerID(Object loginCustomerID) {
        this.loginCustomerID = loginCustomerID;
        return this;
    }

    public Object getGoogleAdsApiVersion() {
        return this.googleAdsApiVersion;
    }

    public GoogleAdWordsLinkedService setGoogleAdsApiVersion(Object googleAdsApiVersion) {
        this.googleAdsApiVersion = googleAdsApiVersion;
        return this;
    }

    public Object getSupportLegacyDataTypes() {
        return this.supportLegacyDataTypes;
    }

    public GoogleAdWordsLinkedService setSupportLegacyDataTypes(Object supportLegacyDataTypes) {
        this.supportLegacyDataTypes = supportLegacyDataTypes;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public GoogleAdWordsLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public GoogleAdWordsLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public GoogleAdWordsLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public GoogleAdWordsLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public GoogleAdWordsLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public GoogleAdWordsLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionProperties != null || this.clientCustomerID != null || this.developerToken != null || this.authenticationType != null || this.refreshToken != null || this.clientId != null || this.clientSecret != null || this.email != null || this.keyFilePath != null || this.trustedCertPath != null || this.useSystemTrustStore != null || this.privateKey != null || this.loginCustomerID != null || this.googleAdsApiVersion != null || this.supportLegacyDataTypes != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.connectionProperties != null) {
                jsonWriter.writeUntypedField("connectionProperties", this.connectionProperties);
            }
            if (this.clientCustomerID != null) {
                jsonWriter.writeUntypedField("clientCustomerID", this.clientCustomerID);
            }
            jsonWriter.writeJsonField("developerToken", (JsonSerializable)this.developerToken);
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            jsonWriter.writeJsonField("refreshToken", (JsonSerializable)this.refreshToken);
            if (this.clientId != null) {
                jsonWriter.writeUntypedField("clientId", this.clientId);
            }
            jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
            if (this.email != null) {
                jsonWriter.writeUntypedField("email", this.email);
            }
            if (this.keyFilePath != null) {
                jsonWriter.writeUntypedField("keyFilePath", this.keyFilePath);
            }
            if (this.trustedCertPath != null) {
                jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
            }
            if (this.useSystemTrustStore != null) {
                jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
            }
            jsonWriter.writeJsonField("privateKey", (JsonSerializable)this.privateKey);
            if (this.loginCustomerID != null) {
                jsonWriter.writeUntypedField("loginCustomerID", this.loginCustomerID);
            }
            if (this.googleAdsApiVersion != null) {
                jsonWriter.writeUntypedField("googleAdsApiVersion", this.googleAdsApiVersion);
            }
            if (this.supportLegacyDataTypes != null) {
                jsonWriter.writeUntypedField("supportLegacyDataTypes", this.supportLegacyDataTypes);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GoogleAdWordsLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleAdWordsLinkedService)jsonReader.readObject(reader -> {
            GoogleAdWordsLinkedService deserializedGoogleAdWordsLinkedService = new GoogleAdWordsLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedGoogleAdWordsLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedGoogleAdWordsLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionProperties".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.connectionProperties = reader.readUntyped();
                            continue;
                        }
                        if ("clientCustomerID".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.clientCustomerID = reader.readUntyped();
                            continue;
                        }
                        if ("developerToken".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.developerToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.authenticationType = GoogleAdWordsAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("refreshToken".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.refreshToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("clientSecret".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.clientSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("email".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.email = reader.readUntyped();
                            continue;
                        }
                        if ("keyFilePath".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.keyFilePath = reader.readUntyped();
                            continue;
                        }
                        if ("trustedCertPath".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.trustedCertPath = reader.readUntyped();
                            continue;
                        }
                        if ("useSystemTrustStore".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.useSystemTrustStore = reader.readUntyped();
                            continue;
                        }
                        if ("privateKey".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.privateKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("loginCustomerID".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.loginCustomerID = reader.readUntyped();
                            continue;
                        }
                        if ("googleAdsApiVersion".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.googleAdsApiVersion = reader.readUntyped();
                            continue;
                        }
                        if ("supportLegacyDataTypes".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.supportLegacyDataTypes = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedGoogleAdWordsLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGoogleAdWordsLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedGoogleAdWordsLinkedService;
        });
    }
}

