/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Activity;
import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.AzureDataExplorerCommandActivity;
import com.azure.analytics.synapse.artifacts.models.AzureFunctionActivity;
import com.azure.analytics.synapse.artifacts.models.AzureMLBatchExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.AzureMLExecutePipelineActivity;
import com.azure.analytics.synapse.artifacts.models.AzureMLUpdateResourceActivity;
import com.azure.analytics.synapse.artifacts.models.CopyActivity;
import com.azure.analytics.synapse.artifacts.models.CustomActivity;
import com.azure.analytics.synapse.artifacts.models.DataLakeAnalyticsUsqlActivity;
import com.azure.analytics.synapse.artifacts.models.DatabricksNotebookActivity;
import com.azure.analytics.synapse.artifacts.models.DatabricksSparkJarActivity;
import com.azure.analytics.synapse.artifacts.models.DatabricksSparkPythonActivity;
import com.azure.analytics.synapse.artifacts.models.DeleteActivity;
import com.azure.analytics.synapse.artifacts.models.ExecuteDataFlowActivity;
import com.azure.analytics.synapse.artifacts.models.ExecuteSsisPackageActivity;
import com.azure.analytics.synapse.artifacts.models.GetMetadataActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightHiveActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightMapReduceActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightPigActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightSparkActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightStreamingActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.LookupActivity;
import com.azure.analytics.synapse.artifacts.models.ScriptActivity;
import com.azure.analytics.synapse.artifacts.models.SqlServerStoredProcedureActivity;
import com.azure.analytics.synapse.artifacts.models.SynapseNotebookActivity;
import com.azure.analytics.synapse.artifacts.models.SynapseSparkJobDefinitionActivity;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.analytics.synapse.artifacts.models.WebActivity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExecutionActivity
extends Activity {
    private String type = "Execution";
    private LinkedServiceReference linkedServiceName;
    private ActivityPolicy policy;

    @Override
    public String getType() {
        return this.type;
    }

    public LinkedServiceReference getLinkedServiceName() {
        return this.linkedServiceName;
    }

    public ExecutionActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    public ActivityPolicy getPolicy() {
        return this.policy;
    }

    public ExecutionActivity setPolicy(ActivityPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Override
    public ExecutionActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public ExecutionActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ExecutionActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public ExecutionActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ExecutionActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn(dependsOn);
        return this;
    }

    @Override
    public ExecutionActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties(userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName);
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExecutionActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutionActivity)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ExecutionActivity executionActivity;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Copy".equals(discriminatorValue)) {
                    executionActivity = CopyActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("HDInsightHive".equals(discriminatorValue)) {
                    executionActivity = HDInsightHiveActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("HDInsightPig".equals(discriminatorValue)) {
                    executionActivity = HDInsightPigActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("HDInsightMapReduce".equals(discriminatorValue)) {
                    executionActivity = HDInsightMapReduceActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("HDInsightStreaming".equals(discriminatorValue)) {
                    executionActivity = HDInsightStreamingActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("HDInsightSpark".equals(discriminatorValue)) {
                    executionActivity = HDInsightSparkActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("ExecuteSSISPackage".equals(discriminatorValue)) {
                    executionActivity = ExecuteSsisPackageActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("Custom".equals(discriminatorValue)) {
                    executionActivity = CustomActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("SqlServerStoredProcedure".equals(discriminatorValue)) {
                    executionActivity = SqlServerStoredProcedureActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("Delete".equals(discriminatorValue)) {
                    executionActivity = DeleteActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("AzureDataExplorerCommand".equals(discriminatorValue)) {
                    executionActivity = AzureDataExplorerCommandActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("Lookup".equals(discriminatorValue)) {
                    executionActivity = LookupActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("WebActivity".equals(discriminatorValue)) {
                    executionActivity = WebActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("GetMetadata".equals(discriminatorValue)) {
                    executionActivity = GetMetadataActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("AzureMLBatchExecution".equals(discriminatorValue)) {
                    executionActivity = AzureMLBatchExecutionActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("AzureMLUpdateResource".equals(discriminatorValue)) {
                    executionActivity = AzureMLUpdateResourceActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("AzureMLExecutePipeline".equals(discriminatorValue)) {
                    executionActivity = AzureMLExecutePipelineActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("DataLakeAnalyticsU-SQL".equals(discriminatorValue)) {
                    executionActivity = DataLakeAnalyticsUsqlActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("DatabricksNotebook".equals(discriminatorValue)) {
                    executionActivity = DatabricksNotebookActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("DatabricksSparkJar".equals(discriminatorValue)) {
                    executionActivity = DatabricksSparkJarActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("DatabricksSparkPython".equals(discriminatorValue)) {
                    executionActivity = DatabricksSparkPythonActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("AzureFunctionActivity".equals(discriminatorValue)) {
                    executionActivity = AzureFunctionActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("ExecuteDataFlow".equals(discriminatorValue)) {
                    executionActivity = ExecuteDataFlowActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("Script".equals(discriminatorValue)) {
                    executionActivity = ScriptActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("SynapseNotebook".equals(discriminatorValue)) {
                    executionActivity = SynapseNotebookActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                if ("SparkJob".equals(discriminatorValue)) {
                    executionActivity = SynapseSparkJobDefinitionActivity.fromJson(readerToUse.reset());
                    return executionActivity;
                }
                executionActivity = ExecutionActivity.fromJsonKnownDiscriminator(readerToUse.reset());
                return executionActivity;
            }
        });
    }

    static ExecutionActivity fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ExecutionActivity)jsonReader.readObject(reader -> {
            ExecutionActivity deserializedExecutionActivity = new ExecutionActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExecutionActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExecutionActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedExecutionActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedExecutionActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedExecutionActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedExecutionActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExecutionActivity.type = reader.getString();
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedExecutionActivity.linkedServiceName = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedExecutionActivity.policy = ActivityPolicy.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExecutionActivity.setAdditionalProperties(additionalProperties);
            return deserializedExecutionActivity;
        });
    }
}

