/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.SsisExecutionCredential;
import com.azure.analytics.synapse.artifacts.models.SsisExecutionParameter;
import com.azure.analytics.synapse.artifacts.models.SsisLogLocation;
import com.azure.analytics.synapse.artifacts.models.SsisPackageLocation;
import com.azure.analytics.synapse.artifacts.models.SsisPropertyOverride;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExecuteSsisPackageActivity
extends ExecutionActivity {
    private String type = "ExecuteSSISPackage";
    private SsisPackageLocation packageLocation;
    private Object runtime;
    private Object loggingLevel;
    private Object environmentPath;
    private SsisExecutionCredential executionCredential;
    private IntegrationRuntimeReference connectVia;
    private Map<String, SsisExecutionParameter> projectParameters;
    private Map<String, SsisExecutionParameter> packageParameters;
    private Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers;
    private Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers;
    private Map<String, SsisPropertyOverride> propertyOverrides;
    private SsisLogLocation logLocation;

    @Override
    public String getType() {
        return this.type;
    }

    public SsisPackageLocation getPackageLocation() {
        return this.packageLocation;
    }

    public ExecuteSsisPackageActivity setPackageLocation(SsisPackageLocation packageLocation) {
        this.packageLocation = packageLocation;
        return this;
    }

    public Object getRuntime() {
        return this.runtime;
    }

    public ExecuteSsisPackageActivity setRuntime(Object runtime) {
        this.runtime = runtime;
        return this;
    }

    public Object getLoggingLevel() {
        return this.loggingLevel;
    }

    public ExecuteSsisPackageActivity setLoggingLevel(Object loggingLevel) {
        this.loggingLevel = loggingLevel;
        return this;
    }

    public Object getEnvironmentPath() {
        return this.environmentPath;
    }

    public ExecuteSsisPackageActivity setEnvironmentPath(Object environmentPath) {
        this.environmentPath = environmentPath;
        return this;
    }

    public SsisExecutionCredential getExecutionCredential() {
        return this.executionCredential;
    }

    public ExecuteSsisPackageActivity setExecutionCredential(SsisExecutionCredential executionCredential) {
        this.executionCredential = executionCredential;
        return this;
    }

    public IntegrationRuntimeReference getConnectVia() {
        return this.connectVia;
    }

    public ExecuteSsisPackageActivity setConnectVia(IntegrationRuntimeReference connectVia) {
        this.connectVia = connectVia;
        return this;
    }

    public Map<String, SsisExecutionParameter> getProjectParameters() {
        return this.projectParameters;
    }

    public ExecuteSsisPackageActivity setProjectParameters(Map<String, SsisExecutionParameter> projectParameters) {
        this.projectParameters = projectParameters;
        return this;
    }

    public Map<String, SsisExecutionParameter> getPackageParameters() {
        return this.packageParameters;
    }

    public ExecuteSsisPackageActivity setPackageParameters(Map<String, SsisExecutionParameter> packageParameters) {
        this.packageParameters = packageParameters;
        return this;
    }

    public Map<String, Map<String, SsisExecutionParameter>> getProjectConnectionManagers() {
        return this.projectConnectionManagers;
    }

    public ExecuteSsisPackageActivity setProjectConnectionManagers(Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers) {
        this.projectConnectionManagers = projectConnectionManagers;
        return this;
    }

    public Map<String, Map<String, SsisExecutionParameter>> getPackageConnectionManagers() {
        return this.packageConnectionManagers;
    }

    public ExecuteSsisPackageActivity setPackageConnectionManagers(Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers) {
        this.packageConnectionManagers = packageConnectionManagers;
        return this;
    }

    public Map<String, SsisPropertyOverride> getPropertyOverrides() {
        return this.propertyOverrides;
    }

    public ExecuteSsisPackageActivity setPropertyOverrides(Map<String, SsisPropertyOverride> propertyOverrides) {
        this.propertyOverrides = propertyOverrides;
        return this;
    }

    public SsisLogLocation getLogLocation() {
        return this.logLocation;
    }

    public ExecuteSsisPackageActivity setLogLocation(SsisLogLocation logLocation) {
        this.logLocation = logLocation;
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.packageLocation != null || this.runtime != null || this.loggingLevel != null || this.environmentPath != null || this.executionCredential != null || this.connectVia != null || this.projectParameters != null || this.packageParameters != null || this.projectConnectionManagers != null || this.packageConnectionManagers != null || this.propertyOverrides != null || this.logLocation != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("packageLocation", (JsonSerializable)this.packageLocation);
            if (this.runtime != null) {
                jsonWriter.writeUntypedField("runtime", this.runtime);
            }
            if (this.loggingLevel != null) {
                jsonWriter.writeUntypedField("loggingLevel", this.loggingLevel);
            }
            if (this.environmentPath != null) {
                jsonWriter.writeUntypedField("environmentPath", this.environmentPath);
            }
            jsonWriter.writeJsonField("executionCredential", (JsonSerializable)this.executionCredential);
            jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia);
            jsonWriter.writeMapField("projectParameters", this.projectParameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeMapField("packageParameters", this.packageParameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeMapField("projectConnectionManagers", this.projectConnectionManagers, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
            jsonWriter.writeMapField("packageConnectionManagers", this.packageConnectionManagers, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
            jsonWriter.writeMapField("propertyOverrides", this.propertyOverrides, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeJsonField("logLocation", (JsonSerializable)this.logLocation);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExecuteSsisPackageActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ExecuteSsisPackageActivity)jsonReader.readObject(reader -> {
            ExecuteSsisPackageActivity deserializedExecuteSsisPackageActivity = new ExecuteSsisPackageActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedExecuteSsisPackageActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedExecuteSsisPackageActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("packageLocation".equals(fieldName)) {
                            deserializedExecuteSsisPackageActivity.packageLocation = SsisPackageLocation.fromJson(reader);
                            continue;
                        }
                        if ("runtime".equals(fieldName)) {
                            deserializedExecuteSsisPackageActivity.runtime = reader.readUntyped();
                            continue;
                        }
                        if ("loggingLevel".equals(fieldName)) {
                            deserializedExecuteSsisPackageActivity.loggingLevel = reader.readUntyped();
                            continue;
                        }
                        if ("environmentPath".equals(fieldName)) {
                            deserializedExecuteSsisPackageActivity.environmentPath = reader.readUntyped();
                            continue;
                        }
                        if ("executionCredential".equals(fieldName)) {
                            deserializedExecuteSsisPackageActivity.executionCredential = SsisExecutionCredential.fromJson(reader);
                            continue;
                        }
                        if ("connectVia".equals(fieldName)) {
                            deserializedExecuteSsisPackageActivity.connectVia = IntegrationRuntimeReference.fromJson(reader);
                            continue;
                        }
                        if ("projectParameters".equals(fieldName)) {
                            Map projectParameters;
                            deserializedExecuteSsisPackageActivity.projectParameters = projectParameters = reader.readMap(reader1 -> SsisExecutionParameter.fromJson(reader1));
                            continue;
                        }
                        if ("packageParameters".equals(fieldName)) {
                            Map packageParameters;
                            deserializedExecuteSsisPackageActivity.packageParameters = packageParameters = reader.readMap(reader1 -> SsisExecutionParameter.fromJson(reader1));
                            continue;
                        }
                        if ("projectConnectionManagers".equals(fieldName)) {
                            Map projectConnectionManagers;
                            deserializedExecuteSsisPackageActivity.projectConnectionManagers = projectConnectionManagers = reader.readMap(reader1 -> reader1.readMap(reader2 -> SsisExecutionParameter.fromJson(reader2)));
                            continue;
                        }
                        if ("packageConnectionManagers".equals(fieldName)) {
                            Map packageConnectionManagers;
                            deserializedExecuteSsisPackageActivity.packageConnectionManagers = packageConnectionManagers = reader.readMap(reader1 -> reader1.readMap(reader2 -> SsisExecutionParameter.fromJson(reader2)));
                            continue;
                        }
                        if ("propertyOverrides".equals(fieldName)) {
                            Map propertyOverrides;
                            deserializedExecuteSsisPackageActivity.propertyOverrides = propertyOverrides = reader.readMap(reader1 -> SsisPropertyOverride.fromJson(reader1));
                            continue;
                        }
                        if ("logLocation".equals(fieldName)) {
                            deserializedExecuteSsisPackageActivity.logLocation = SsisLogLocation.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExecuteSsisPackageActivity.setAdditionalProperties(additionalProperties);
            return deserializedExecuteSsisPackageActivity;
        });
    }
}

