/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetCompression;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.DatasetLocation;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExcelDataset
extends Dataset {
    private String type = "Excel";
    private DatasetLocation location;
    private Object sheetName;
    private Object sheetIndex;
    private Object range;
    private Object firstRowAsHeader;
    private DatasetCompression compression;
    private Object nullValue;

    @Override
    public String getType() {
        return this.type;
    }

    public DatasetLocation getLocation() {
        return this.location;
    }

    public ExcelDataset setLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public Object getSheetName() {
        return this.sheetName;
    }

    public ExcelDataset setSheetName(Object sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public Object getSheetIndex() {
        return this.sheetIndex;
    }

    public ExcelDataset setSheetIndex(Object sheetIndex) {
        this.sheetIndex = sheetIndex;
        return this;
    }

    public Object getRange() {
        return this.range;
    }

    public ExcelDataset setRange(Object range) {
        this.range = range;
        return this;
    }

    public Object getFirstRowAsHeader() {
        return this.firstRowAsHeader;
    }

    public ExcelDataset setFirstRowAsHeader(Object firstRowAsHeader) {
        this.firstRowAsHeader = firstRowAsHeader;
        return this;
    }

    public DatasetCompression getCompression() {
        return this.compression;
    }

    public ExcelDataset setCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    public Object getNullValue() {
        return this.nullValue;
    }

    public ExcelDataset setNullValue(Object nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    @Override
    public ExcelDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ExcelDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public ExcelDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public ExcelDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public ExcelDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public ExcelDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public ExcelDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.location != null || this.sheetName != null || this.sheetIndex != null || this.range != null || this.firstRowAsHeader != null || this.compression != null || this.nullValue != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
            if (this.sheetName != null) {
                jsonWriter.writeUntypedField("sheetName", this.sheetName);
            }
            if (this.sheetIndex != null) {
                jsonWriter.writeUntypedField("sheetIndex", this.sheetIndex);
            }
            if (this.range != null) {
                jsonWriter.writeUntypedField("range", this.range);
            }
            if (this.firstRowAsHeader != null) {
                jsonWriter.writeUntypedField("firstRowAsHeader", this.firstRowAsHeader);
            }
            jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
            if (this.nullValue != null) {
                jsonWriter.writeUntypedField("nullValue", this.nullValue);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExcelDataset fromJson(JsonReader jsonReader) throws IOException {
        return (ExcelDataset)jsonReader.readObject(reader -> {
            ExcelDataset deserializedExcelDataset = new ExcelDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedExcelDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExcelDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedExcelDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedExcelDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedExcelDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedExcelDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedExcelDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExcelDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("location".equals(fieldName)) {
                            deserializedExcelDataset.location = DatasetLocation.fromJson(reader);
                            continue;
                        }
                        if ("sheetName".equals(fieldName)) {
                            deserializedExcelDataset.sheetName = reader.readUntyped();
                            continue;
                        }
                        if ("sheetIndex".equals(fieldName)) {
                            deserializedExcelDataset.sheetIndex = reader.readUntyped();
                            continue;
                        }
                        if ("range".equals(fieldName)) {
                            deserializedExcelDataset.range = reader.readUntyped();
                            continue;
                        }
                        if ("firstRowAsHeader".equals(fieldName)) {
                            deserializedExcelDataset.firstRowAsHeader = reader.readUntyped();
                            continue;
                        }
                        if ("compression".equals(fieldName)) {
                            deserializedExcelDataset.compression = DatasetCompression.fromJson(reader);
                            continue;
                        }
                        if ("nullValue".equals(fieldName)) {
                            deserializedExcelDataset.nullValue = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExcelDataset.setAdditionalProperties(additionalProperties);
            return deserializedExcelDataset;
        });
    }
}

