/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.DatasetReference;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.LogStorageSettings;
import com.azure.analytics.synapse.artifacts.models.StoreReadSettings;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DeleteActivity
extends ExecutionActivity {
    private String type = "Delete";
    private Object recursive;
    private Integer maxConcurrentConnections;
    private Object enableLogging;
    private LogStorageSettings logStorageSettings;
    private DatasetReference dataset;
    private StoreReadSettings storeSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getRecursive() {
        return this.recursive;
    }

    public DeleteActivity setRecursive(Object recursive) {
        this.recursive = recursive;
        return this;
    }

    public Integer getMaxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    public DeleteActivity setMaxConcurrentConnections(Integer maxConcurrentConnections) {
        this.maxConcurrentConnections = maxConcurrentConnections;
        return this;
    }

    public Object getEnableLogging() {
        return this.enableLogging;
    }

    public DeleteActivity setEnableLogging(Object enableLogging) {
        this.enableLogging = enableLogging;
        return this;
    }

    public LogStorageSettings getLogStorageSettings() {
        return this.logStorageSettings;
    }

    public DeleteActivity setLogStorageSettings(LogStorageSettings logStorageSettings) {
        this.logStorageSettings = logStorageSettings;
        return this;
    }

    public DatasetReference getDataset() {
        return this.dataset;
    }

    public DeleteActivity setDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    public StoreReadSettings getStoreSettings() {
        return this.storeSettings;
    }

    public DeleteActivity setStoreSettings(StoreReadSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    @Override
    public DeleteActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public DeleteActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public DeleteActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public DeleteActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public DeleteActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public DeleteActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public DeleteActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public DeleteActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.recursive != null || this.maxConcurrentConnections != null || this.enableLogging != null || this.logStorageSettings != null || this.dataset != null || this.storeSettings != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.recursive != null) {
                jsonWriter.writeUntypedField("recursive", this.recursive);
            }
            jsonWriter.writeNumberField("maxConcurrentConnections", (Number)this.maxConcurrentConnections);
            if (this.enableLogging != null) {
                jsonWriter.writeUntypedField("enableLogging", this.enableLogging);
            }
            jsonWriter.writeJsonField("logStorageSettings", (JsonSerializable)this.logStorageSettings);
            jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset);
            jsonWriter.writeJsonField("storeSettings", (JsonSerializable)this.storeSettings);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DeleteActivity fromJson(JsonReader jsonReader) throws IOException {
        return (DeleteActivity)jsonReader.readObject(reader -> {
            DeleteActivity deserializedDeleteActivity = new DeleteActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDeleteActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDeleteActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDeleteActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedDeleteActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedDeleteActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedDeleteActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedDeleteActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedDeleteActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDeleteActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("recursive".equals(fieldName)) {
                            deserializedDeleteActivity.recursive = reader.readUntyped();
                            continue;
                        }
                        if ("maxConcurrentConnections".equals(fieldName)) {
                            deserializedDeleteActivity.maxConcurrentConnections = (Integer)reader.getNullable(JsonReader::getInt);
                            continue;
                        }
                        if ("enableLogging".equals(fieldName)) {
                            deserializedDeleteActivity.enableLogging = reader.readUntyped();
                            continue;
                        }
                        if ("logStorageSettings".equals(fieldName)) {
                            deserializedDeleteActivity.logStorageSettings = LogStorageSettings.fromJson(reader);
                            continue;
                        }
                        if ("dataset".equals(fieldName)) {
                            deserializedDeleteActivity.dataset = DatasetReference.fromJson(reader);
                            continue;
                        }
                        if ("storeSettings".equals(fieldName)) {
                            deserializedDeleteActivity.storeSettings = StoreReadSettings.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDeleteActivity.setAdditionalProperties(additionalProperties);
            return deserializedDeleteActivity;
        });
    }
}

