/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AvroFormat;
import com.azure.analytics.synapse.artifacts.models.JsonFormat;
import com.azure.analytics.synapse.artifacts.models.OrcFormat;
import com.azure.analytics.synapse.artifacts.models.ParquetFormat;
import com.azure.analytics.synapse.artifacts.models.TextFormat;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class DatasetStorageFormat
implements JsonSerializable<DatasetStorageFormat> {
    private String type = "DatasetStorageFormat";
    private Object serializer;
    private Object deserializer;
    private Map<String, Object> additionalProperties;

    public String getType() {
        return this.type;
    }

    public Object getSerializer() {
        return this.serializer;
    }

    public DatasetStorageFormat setSerializer(Object serializer) {
        this.serializer = serializer;
        return this;
    }

    public Object getDeserializer() {
        return this.deserializer;
    }

    public DatasetStorageFormat setDeserializer(Object deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public DatasetStorageFormat setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        if (this.serializer != null) {
            jsonWriter.writeUntypedField("serializer", this.serializer);
        }
        if (this.deserializer != null) {
            jsonWriter.writeUntypedField("deserializer", this.deserializer);
        }
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DatasetStorageFormat fromJson(JsonReader jsonReader) throws IOException {
        return (DatasetStorageFormat)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DatasetStorageFormat datasetStorageFormat;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("TextFormat".equals(discriminatorValue)) {
                    datasetStorageFormat = TextFormat.fromJson(readerToUse.reset());
                    return datasetStorageFormat;
                }
                if ("JsonFormat".equals(discriminatorValue)) {
                    datasetStorageFormat = JsonFormat.fromJson(readerToUse.reset());
                    return datasetStorageFormat;
                }
                if ("AvroFormat".equals(discriminatorValue)) {
                    datasetStorageFormat = AvroFormat.fromJson(readerToUse.reset());
                    return datasetStorageFormat;
                }
                if ("OrcFormat".equals(discriminatorValue)) {
                    datasetStorageFormat = OrcFormat.fromJson(readerToUse.reset());
                    return datasetStorageFormat;
                }
                if ("ParquetFormat".equals(discriminatorValue)) {
                    datasetStorageFormat = ParquetFormat.fromJson(readerToUse.reset());
                    return datasetStorageFormat;
                }
                datasetStorageFormat = DatasetStorageFormat.fromJsonKnownDiscriminator(readerToUse.reset());
                return datasetStorageFormat;
            }
        });
    }

    static DatasetStorageFormat fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DatasetStorageFormat)jsonReader.readObject(reader -> {
            DatasetStorageFormat deserializedDatasetStorageFormat = new DatasetStorageFormat();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedDatasetStorageFormat.type = reader.getString();
                    continue;
                }
                if ("serializer".equals(fieldName)) {
                    deserializedDatasetStorageFormat.serializer = reader.readUntyped();
                    continue;
                }
                if ("deserializer".equals(fieldName)) {
                    deserializedDatasetStorageFormat.deserializer = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDatasetStorageFormat.additionalProperties = additionalProperties;
            return deserializedDatasetStorageFormat;
        });
    }
}

