/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CustomDataSourceLinkedService
extends LinkedService {
    private String type = "CustomDataSource";
    private Object typeProperties;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getTypeProperties() {
        return this.typeProperties;
    }

    public CustomDataSourceLinkedService setTypeProperties(Object typeProperties) {
        this.typeProperties = typeProperties;
        return this;
    }

    @Override
    public CustomDataSourceLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public CustomDataSourceLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public CustomDataSourceLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CustomDataSourceLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public CustomDataSourceLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeUntypedField("typeProperties", this.typeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CustomDataSourceLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (CustomDataSourceLinkedService)jsonReader.readObject(reader -> {
            CustomDataSourceLinkedService deserializedCustomDataSourceLinkedService = new CustomDataSourceLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedCustomDataSourceLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedCustomDataSourceLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCustomDataSourceLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedCustomDataSourceLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedCustomDataSourceLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedCustomDataSourceLinkedService.typeProperties = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomDataSourceLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCustomDataSourceLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedCustomDataSourceLinkedService;
        });
    }
}

