/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.CustomActivityReferenceObject;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CustomActivity
extends ExecutionActivity {
    private String type = "Custom";
    private Object command;
    private LinkedServiceReference resourceLinkedService;
    private Object folderPath;
    private CustomActivityReferenceObject referenceObjects;
    private Map<String, Object> extendedProperties;
    private Object retentionTimeInDays;
    private Object autoUserSpecification;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getCommand() {
        return this.command;
    }

    public CustomActivity setCommand(Object command) {
        this.command = command;
        return this;
    }

    public LinkedServiceReference getResourceLinkedService() {
        return this.resourceLinkedService;
    }

    public CustomActivity setResourceLinkedService(LinkedServiceReference resourceLinkedService) {
        this.resourceLinkedService = resourceLinkedService;
        return this;
    }

    public Object getFolderPath() {
        return this.folderPath;
    }

    public CustomActivity setFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public CustomActivityReferenceObject getReferenceObjects() {
        return this.referenceObjects;
    }

    public CustomActivity setReferenceObjects(CustomActivityReferenceObject referenceObjects) {
        this.referenceObjects = referenceObjects;
        return this;
    }

    public Map<String, Object> getExtendedProperties() {
        return this.extendedProperties;
    }

    public CustomActivity setExtendedProperties(Map<String, Object> extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    public Object getRetentionTimeInDays() {
        return this.retentionTimeInDays;
    }

    public CustomActivity setRetentionTimeInDays(Object retentionTimeInDays) {
        this.retentionTimeInDays = retentionTimeInDays;
        return this;
    }

    public Object getAutoUserSpecification() {
        return this.autoUserSpecification;
    }

    public CustomActivity setAutoUserSpecification(Object autoUserSpecification) {
        this.autoUserSpecification = autoUserSpecification;
        return this;
    }

    @Override
    public CustomActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public CustomActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public CustomActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public CustomActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CustomActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public CustomActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public CustomActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public CustomActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.command != null || this.resourceLinkedService != null || this.folderPath != null || this.referenceObjects != null || this.extendedProperties != null || this.retentionTimeInDays != null || this.autoUserSpecification != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("command", this.command);
            jsonWriter.writeJsonField("resourceLinkedService", (JsonSerializable)this.resourceLinkedService);
            if (this.folderPath != null) {
                jsonWriter.writeUntypedField("folderPath", this.folderPath);
            }
            jsonWriter.writeJsonField("referenceObjects", (JsonSerializable)this.referenceObjects);
            jsonWriter.writeMapField("extendedProperties", this.extendedProperties, (writer, element) -> writer.writeUntyped(element));
            if (this.retentionTimeInDays != null) {
                jsonWriter.writeUntypedField("retentionTimeInDays", this.retentionTimeInDays);
            }
            if (this.autoUserSpecification != null) {
                jsonWriter.writeUntypedField("autoUserSpecification", this.autoUserSpecification);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CustomActivity fromJson(JsonReader jsonReader) throws IOException {
        return (CustomActivity)jsonReader.readObject(reader -> {
            CustomActivity deserializedCustomActivity = new CustomActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCustomActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCustomActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedCustomActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedCustomActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedCustomActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedCustomActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedCustomActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedCustomActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("command".equals(fieldName)) {
                            deserializedCustomActivity.command = reader.readUntyped();
                            continue;
                        }
                        if ("resourceLinkedService".equals(fieldName)) {
                            deserializedCustomActivity.resourceLinkedService = LinkedServiceReference.fromJson(reader);
                            continue;
                        }
                        if ("folderPath".equals(fieldName)) {
                            deserializedCustomActivity.folderPath = reader.readUntyped();
                            continue;
                        }
                        if ("referenceObjects".equals(fieldName)) {
                            deserializedCustomActivity.referenceObjects = CustomActivityReferenceObject.fromJson(reader);
                            continue;
                        }
                        if ("extendedProperties".equals(fieldName)) {
                            Map extendedProperties;
                            deserializedCustomActivity.extendedProperties = extendedProperties = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("retentionTimeInDays".equals(fieldName)) {
                            deserializedCustomActivity.retentionTimeInDays = reader.readUntyped();
                            continue;
                        }
                        if ("autoUserSpecification".equals(fieldName)) {
                            deserializedCustomActivity.autoUserSpecification = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCustomActivity.setAdditionalProperties(additionalProperties);
            return deserializedCustomActivity;
        });
    }
}

